@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.AlertTemplateConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property annotations Alert template annotations.
 * @property id Alert template id.
 * @property lang Alert template language including `cn`, `en`.
 * @property tokens Alert template tokens.
 * @property type Alert template type including `sys`, `user`.
 */
public data class AlertTemplateConfigurationArgs(
    public val annotations: Output<Map<String, String>>? = null,
    public val id: Output<String>,
    public val lang: Output<String>? = null,
    public val tokens: Output<Map<String, String>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.AlertTemplateConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.AlertTemplateConfigurationArgs =
        com.pulumi.alicloud.log.inputs.AlertTemplateConfigurationArgs.builder()
            .annotations(
                annotations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .id(id.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .tokens(tokens?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertTemplateConfigurationArgs].
 */
@PulumiTagMarker
public class AlertTemplateConfigurationArgsBuilder internal constructor() {
    private var annotations: Output<Map<String, String>>? = null

    private var id: Output<String>? = null

    private var lang: Output<String>? = null

    private var tokens: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Alert template annotations.
     */
    @JvmName("taimdooimdlpqtqd")
    public suspend fun annotations(`value`: Output<Map<String, String>>) {
        this.annotations = value
    }

    /**
     * @param value Alert template id.
     */
    @JvmName("qnibuxqccxtftbkg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Alert template language including `cn`, `en`.
     */
    @JvmName("ifdicatmcenxujfi")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value Alert template tokens.
     */
    @JvmName("knkmcawecwfrqrad")
    public suspend fun tokens(`value`: Output<Map<String, String>>) {
        this.tokens = value
    }

    /**
     * @param value Alert template type including `sys`, `user`.
     */
    @JvmName("palfvlfsdhfhfanc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Alert template annotations.
     */
    @JvmName("fiqqavgjwreepvbu")
    public suspend fun annotations(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values Alert template annotations.
     */
    @JvmName("cvtkqcgwtbvqtbhc")
    public fun annotations(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Alert template id.
     */
    @JvmName("jmymoicaktdkmncp")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Alert template language including `cn`, `en`.
     */
    @JvmName("jnfdcartkbfojyqr")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value Alert template tokens.
     */
    @JvmName("magbauxturhgpukn")
    public suspend fun tokens(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokens = mapped
    }

    /**
     * @param values Alert template tokens.
     */
    @JvmName("dpapwrfoowdvjlmk")
    public fun tokens(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokens = mapped
    }

    /**
     * @param value Alert template type including `sys`, `user`.
     */
    @JvmName("utgjvhdqllhmhvnb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertTemplateConfigurationArgs = AlertTemplateConfigurationArgs(
        annotations = annotations,
        id = id ?: throw PulumiNullFieldException("id"),
        lang = lang,
        tokens = tokens,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
