@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.EtlEtlSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessKeyId Delivery target logstore access key id.
 * @property accessKeySecret Delivery target logstore access key secret.
 * @property endpoint Delivery target logstore region.
 * @property kmsEncryptedAccessKeyId An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
 * @property kmsEncryptedAccessKeySecret An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
 * @property logstore Delivery target logstore.
 * @property name Delivery target name.
 * @property project The project where the target logstore is delivered.
 * @property roleArn Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
 * @property type ETL sinks type, the default value is AliyunLOG.
 * > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
 */
public data class EtlEtlSinkArgs(
    public val accessKeyId: Output<String>? = null,
    public val accessKeySecret: Output<String>? = null,
    public val endpoint: Output<String>,
    public val kmsEncryptedAccessKeyId: Output<String>? = null,
    public val kmsEncryptedAccessKeySecret: Output<String>? = null,
    public val logstore: Output<String>,
    public val name: Output<String>,
    public val project: Output<String>,
    public val roleArn: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.EtlEtlSinkArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.EtlEtlSinkArgs =
        com.pulumi.alicloud.log.inputs.EtlEtlSinkArgs.builder()
            .accessKeyId(accessKeyId?.applyValue({ args0 -> args0 }))
            .accessKeySecret(accessKeySecret?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .kmsEncryptedAccessKeyId(kmsEncryptedAccessKeyId?.applyValue({ args0 -> args0 }))
            .kmsEncryptedAccessKeySecret(kmsEncryptedAccessKeySecret?.applyValue({ args0 -> args0 }))
            .logstore(logstore.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .project(project.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EtlEtlSinkArgs].
 */
@PulumiTagMarker
public class EtlEtlSinkArgsBuilder internal constructor() {
    private var accessKeyId: Output<String>? = null

    private var accessKeySecret: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var kmsEncryptedAccessKeyId: Output<String>? = null

    private var kmsEncryptedAccessKeySecret: Output<String>? = null

    private var logstore: Output<String>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Delivery target logstore access key id.
     */
    @JvmName("oabkknrbjsbfymrk")
    public suspend fun accessKeyId(`value`: Output<String>) {
        this.accessKeyId = value
    }

    /**
     * @param value Delivery target logstore access key secret.
     */
    @JvmName("jrayaddmfdxcrqky")
    public suspend fun accessKeySecret(`value`: Output<String>) {
        this.accessKeySecret = value
    }

    /**
     * @param value Delivery target logstore region.
     */
    @JvmName("uuvguuvlqnglddyb")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
     */
    @JvmName("fyyrxciylglinotr")
    public suspend fun kmsEncryptedAccessKeyId(`value`: Output<String>) {
        this.kmsEncryptedAccessKeyId = value
    }

    /**
     * @param value An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
     */
    @JvmName("wjprxgkuyaoslkxn")
    public suspend fun kmsEncryptedAccessKeySecret(`value`: Output<String>) {
        this.kmsEncryptedAccessKeySecret = value
    }

    /**
     * @param value Delivery target logstore.
     */
    @JvmName("vnmhkstbavuyeeqb")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value Delivery target name.
     */
    @JvmName("vxvplcuucjorxvgc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The project where the target logstore is delivered.
     */
    @JvmName("vyjiulvsaqbivvjr")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
     */
    @JvmName("hwpfxoihxbcjpxln")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value ETL sinks type, the default value is AliyunLOG.
     * > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
     */
    @JvmName("iidppmkhwgjythck")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Delivery target logstore access key id.
     */
    @JvmName("soikddsuvgesmgey")
    public suspend fun accessKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKeyId = mapped
    }

    /**
     * @param value Delivery target logstore access key secret.
     */
    @JvmName("iqbbrgcgtoklvdrw")
    public suspend fun accessKeySecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKeySecret = mapped
    }

    /**
     * @param value Delivery target logstore region.
     */
    @JvmName("xbviwspbwmnlpkck")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
     */
    @JvmName("udraogcejcuiditv")
    public suspend fun kmsEncryptedAccessKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedAccessKeyId = mapped
    }

    /**
     * @param value An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
     */
    @JvmName("bqnrewncxarovtcm")
    public suspend fun kmsEncryptedAccessKeySecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedAccessKeySecret = mapped
    }

    /**
     * @param value Delivery target logstore.
     */
    @JvmName("swciugrfutclgxwj")
    public suspend fun logstore(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value Delivery target name.
     */
    @JvmName("ugdcojcemnuenuwv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The project where the target logstore is delivered.
     */
    @JvmName("ncxsjperytjrjkor")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
     */
    @JvmName("vmgiadhaleukwusk")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value ETL sinks type, the default value is AliyunLOG.
     * > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
     */
    @JvmName("hcfyffsbwiswummy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EtlEtlSinkArgs = EtlEtlSinkArgs(
        accessKeyId = accessKeyId,
        accessKeySecret = accessKeySecret,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        kmsEncryptedAccessKeyId = kmsEncryptedAccessKeyId,
        kmsEncryptedAccessKeySecret = kmsEncryptedAccessKeySecret,
        logstore = logstore ?: throw PulumiNullFieldException("logstore"),
        name = name ?: throw PulumiNullFieldException("name"),
        project = project ?: throw PulumiNullFieldException("project"),
        roleArn = roleArn,
        type = type,
    )
}
