@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.GetAlertResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlertResource.
 * @property lang The lang of alert center resource when type is user.
 * @property project The project of alert resource when type is project.
 * @property type The type of alert resources, must be user or project, 'user' for init aliyuncloud account's alert center resource, including project named sls-alert-{uid}-{region} and some dashboards; 'project' for init project's alert resource, including logstore named internal-alert-history and alert dashboard.
 */
public data class GetAlertResourcePlainArgs(
    public val lang: String? = null,
    public val project: String? = null,
    public val type: String,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.GetAlertResourcePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.GetAlertResourcePlainArgs =
        com.pulumi.alicloud.log.inputs.GetAlertResourcePlainArgs.builder()
            .lang(lang?.let({ args0 -> args0 }))
            .project(project?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlertResourcePlainArgs].
 */
@PulumiTagMarker
public class GetAlertResourcePlainArgsBuilder internal constructor() {
    private var lang: String? = null

    private var project: String? = null

    private var type: String? = null

    /**
     * @param value The lang of alert center resource when type is user.
     */
    @JvmName("onyqoajvtyagaixk")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value The project of alert resource when type is project.
     */
    @JvmName("tukmibswyukrjyxe")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.project = mapped
    }

    /**
     * @param value The type of alert resources, must be user or project, 'user' for init aliyuncloud account's alert center resource, including project named sls-alert-{uid}-{region} and some dashboards; 'project' for init project's alert resource, including logstore named internal-alert-history and alert dashboard.
     */
    @JvmName("itmopciqyjbvrfpq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetAlertResourcePlainArgs = GetAlertResourcePlainArgs(
        lang = lang,
        project = project,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
