@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getService.
 * @property enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
 * > **NOTE:** Setting `enable = "On"` to open the Log service that means you have read and agreed the [Log Terms of Service](https://help.aliyun.com/document_detail/53476.html). The service can not closed once it is opened.
 */
public data class GetServicePlainArgs(
    public val enable: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.GetServicePlainArgs =
        com.pulumi.alicloud.log.inputs.GetServicePlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the Log service that means you have read and agreed the [Log Terms of Service](https://help.aliyun.com/document_detail/53476.html). The service can not closed once it is opened.
     */
    @JvmName("evofodigkjyqoeer")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        enable = enable,
    )
}
