@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.GetStoresPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStores.
 * @property ids A list of store IDs.
 * @property nameRegex A regex string to filter results by store name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property project
 */
public data class GetStoresPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val project: String,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.GetStoresPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.GetStoresPlainArgs =
        com.pulumi.alicloud.log.inputs.GetStoresPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStoresPlainArgs].
 */
@PulumiTagMarker
public class GetStoresPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var project: String? = null

    /**
     * @param value A list of store IDs.
     */
    @JvmName("hebxwjgtgwdgkeff")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of store IDs.
     */
    @JvmName("bushujkjohiyytmb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by store name.
     */
    @JvmName("qjlnuqgsgbikdofm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rgybabhmkvihnxuo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ielyvxkdrrouusbm")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetStoresPlainArgs = GetStoresPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
