@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.OssExportConfigColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the key.
 * @property type Type of configuration name.
 */
public data class OssExportConfigColumnArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.OssExportConfigColumnArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.OssExportConfigColumnArgs =
        com.pulumi.alicloud.log.inputs.OssExportConfigColumnArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OssExportConfigColumnArgs].
 */
@PulumiTagMarker
public class OssExportConfigColumnArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the key.
     */
    @JvmName("nfjuttcdqxuqakow")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of configuration name.
     */
    @JvmName("oqlwiadfogpcovwm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the key.
     */
    @JvmName("qeryvoqjfpcyixsc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of configuration name.
     */
    @JvmName("cipajurdyehxqyqf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OssExportConfigColumnArgs = OssExportConfigColumnArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
