@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.OssShipperParquetConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name
 * @property type
 */
public data class OssShipperParquetConfigArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.OssShipperParquetConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.OssShipperParquetConfigArgs =
        com.pulumi.alicloud.log.inputs.OssShipperParquetConfigArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OssShipperParquetConfigArgs].
 */
@PulumiTagMarker
public class OssShipperParquetConfigArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("rgpmtulphywoaxvc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("rpvqdejqdymiosvx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("ociocapyqlmyniqy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("yriuivowfnaxqegv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OssShipperParquetConfigArgs = OssShipperParquetConfigArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
