@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.StoreEncryptConfArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enable Enable encryption. Default false.
 * @property encryptType Supported encryption type, only supports `default`(AES), `m4`.
 * @property userCmkInfo User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
 */
public data class StoreEncryptConfArgs(
    public val enable: Output<Boolean>? = null,
    public val encryptType: Output<String>? = null,
    public val userCmkInfo: Output<StoreEncryptConfUserCmkInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.StoreEncryptConfArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.StoreEncryptConfArgs =
        com.pulumi.alicloud.log.inputs.StoreEncryptConfArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .encryptType(encryptType?.applyValue({ args0 -> args0 }))
            .userCmkInfo(userCmkInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StoreEncryptConfArgs].
 */
@PulumiTagMarker
public class StoreEncryptConfArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var encryptType: Output<String>? = null

    private var userCmkInfo: Output<StoreEncryptConfUserCmkInfoArgs>? = null

    /**
     * @param value Enable encryption. Default false.
     */
    @JvmName("cyapbsijkllomxdi")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Supported encryption type, only supports `default`(AES), `m4`.
     */
    @JvmName("wuqxsliujnxkdvnj")
    public suspend fun encryptType(`value`: Output<String>) {
        this.encryptType = value
    }

    /**
     * @param value User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
     */
    @JvmName("cyfketsfrtkqiglq")
    public suspend fun userCmkInfo(`value`: Output<StoreEncryptConfUserCmkInfoArgs>) {
        this.userCmkInfo = value
    }

    /**
     * @param value Enable encryption. Default false.
     */
    @JvmName("moimnixkgbrrepoo")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Supported encryption type, only supports `default`(AES), `m4`.
     */
    @JvmName("oahhxyddjaslbdas")
    public suspend fun encryptType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptType = mapped
    }

    /**
     * @param value User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
     */
    @JvmName("caswyaonbjabcogh")
    public suspend fun userCmkInfo(`value`: StoreEncryptConfUserCmkInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userCmkInfo = mapped
    }

    /**
     * @param argument User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
     */
    @JvmName("dxsdtlavbsxtebjv")
    public suspend fun userCmkInfo(argument: suspend StoreEncryptConfUserCmkInfoArgsBuilder.() -> Unit) {
        val toBeMapped = StoreEncryptConfUserCmkInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userCmkInfo = mapped
    }

    internal fun build(): StoreEncryptConfArgs = StoreEncryptConfArgs(
        enable = enable,
        encryptType = encryptType,
        userCmkInfo = userCmkInfo,
    )
}
