@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.StoreEncryptConfUserCmkInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn Role arn.
 * @property cmkKeyId User master key id.
 * @property regionId Region id where the user master key id is located.
 */
public data class StoreEncryptConfUserCmkInfoArgs(
    public val arn: Output<String>? = null,
    public val cmkKeyId: Output<String>? = null,
    public val regionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.StoreEncryptConfUserCmkInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.StoreEncryptConfUserCmkInfoArgs =
        com.pulumi.alicloud.log.inputs.StoreEncryptConfUserCmkInfoArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .cmkKeyId(cmkKeyId?.applyValue({ args0 -> args0 }))
            .regionId(regionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StoreEncryptConfUserCmkInfoArgs].
 */
@PulumiTagMarker
public class StoreEncryptConfUserCmkInfoArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var cmkKeyId: Output<String>? = null

    private var regionId: Output<String>? = null

    /**
     * @param value Role arn.
     */
    @JvmName("rmbnsooxgxhftkbg")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value User master key id.
     */
    @JvmName("vgujguuuveicrjlk")
    public suspend fun cmkKeyId(`value`: Output<String>) {
        this.cmkKeyId = value
    }

    /**
     * @param value Region id where the user master key id is located.
     */
    @JvmName("jfnxuccesebfvagv")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value Role arn.
     */
    @JvmName("eiirdokmcdlyovlq")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value User master key id.
     */
    @JvmName("eprwrgkteuobrfgu")
    public suspend fun cmkKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cmkKeyId = mapped
    }

    /**
     * @param value Region id where the user master key id is located.
     */
    @JvmName("degcvswsqfjkehqk")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    internal fun build(): StoreEncryptConfUserCmkInfoArgs = StoreEncryptConfUserCmkInfoArgs(
        arn = arn,
        cmkKeyId = cmkKeyId,
        regionId = regionId,
    )
}
