@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alias The alias of one field
 * @property caseSensitive Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
 * @property enableAnalytics Whether to enable field analytics. Default to true.
 * @property includeChinese Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
 * @property jsonKeys Use nested index when type is json
 * @property name The field name, which is unique in the same log store.
 * @property token The string of several split words, like "\r", "#". It is valid when "type" is "text" or "json".
 * @property type The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
 */
public data class StoreIndexFieldSearchArgs(
    public val alias: Output<String>? = null,
    public val caseSensitive: Output<Boolean>? = null,
    public val enableAnalytics: Output<Boolean>? = null,
    public val includeChinese: Output<Boolean>? = null,
    public val jsonKeys: Output<List<StoreIndexFieldSearchJsonKeyArgs>>? = null,
    public val name: Output<String>,
    public val token: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchArgs =
        com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .caseSensitive(caseSensitive?.applyValue({ args0 -> args0 }))
            .enableAnalytics(enableAnalytics?.applyValue({ args0 -> args0 }))
            .includeChinese(includeChinese?.applyValue({ args0 -> args0 }))
            .jsonKeys(
                jsonKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .token(token?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StoreIndexFieldSearchArgs].
 */
@PulumiTagMarker
public class StoreIndexFieldSearchArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var caseSensitive: Output<Boolean>? = null

    private var enableAnalytics: Output<Boolean>? = null

    private var includeChinese: Output<Boolean>? = null

    private var jsonKeys: Output<List<StoreIndexFieldSearchJsonKeyArgs>>? = null

    private var name: Output<String>? = null

    private var token: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The alias of one field
     */
    @JvmName("nhilgwprbfeygqak")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
     */
    @JvmName("umiiafvoskyrpxti")
    public suspend fun caseSensitive(`value`: Output<Boolean>) {
        this.caseSensitive = value
    }

    /**
     * @param value Whether to enable field analytics. Default to true.
     */
    @JvmName("bbuppwdrjxuvgqaf")
    public suspend fun enableAnalytics(`value`: Output<Boolean>) {
        this.enableAnalytics = value
    }

    /**
     * @param value Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
     */
    @JvmName("parovcjbjtswdwdr")
    public suspend fun includeChinese(`value`: Output<Boolean>) {
        this.includeChinese = value
    }

    /**
     * @param value Use nested index when type is json
     */
    @JvmName("bbmkgexrjpbsqior")
    public suspend fun jsonKeys(`value`: Output<List<StoreIndexFieldSearchJsonKeyArgs>>) {
        this.jsonKeys = value
    }

    @JvmName("ltnntmrdmphwwpjk")
    public suspend fun jsonKeys(vararg values: Output<StoreIndexFieldSearchJsonKeyArgs>) {
        this.jsonKeys = Output.all(values.asList())
    }

    /**
     * @param values Use nested index when type is json
     */
    @JvmName("dwapbcjhgqpbywmb")
    public suspend fun jsonKeys(values: List<Output<StoreIndexFieldSearchJsonKeyArgs>>) {
        this.jsonKeys = Output.all(values)
    }

    /**
     * @param value The field name, which is unique in the same log store.
     */
    @JvmName("famkudawyoddycnk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The string of several split words, like "\r", "#". It is valid when "type" is "text" or "json".
     */
    @JvmName("amyrlxigqrrvnwyl")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
     */
    @JvmName("sdhrjjpojuncemhw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The alias of one field
     */
    @JvmName("bnlcvemsqhqjoemj")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
     */
    @JvmName("knehfvfiltpqiyqa")
    public suspend fun caseSensitive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caseSensitive = mapped
    }

    /**
     * @param value Whether to enable field analytics. Default to true.
     */
    @JvmName("xmyceigmoshmwovn")
    public suspend fun enableAnalytics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAnalytics = mapped
    }

    /**
     * @param value Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
     */
    @JvmName("evvhggsgiuffsufi")
    public suspend fun includeChinese(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeChinese = mapped
    }

    /**
     * @param value Use nested index when type is json
     */
    @JvmName("aokwmcsgaepferac")
    public suspend fun jsonKeys(`value`: List<StoreIndexFieldSearchJsonKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonKeys = mapped
    }

    /**
     * @param argument Use nested index when type is json
     */
    @JvmName("tlqgdlhhlwajccnd")
    public suspend fun jsonKeys(argument: List<suspend StoreIndexFieldSearchJsonKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StoreIndexFieldSearchJsonKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jsonKeys = mapped
    }

    /**
     * @param argument Use nested index when type is json
     */
    @JvmName("epofrsmlnaubjcjv")
    public suspend fun jsonKeys(vararg argument: suspend StoreIndexFieldSearchJsonKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StoreIndexFieldSearchJsonKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jsonKeys = mapped
    }

    /**
     * @param argument Use nested index when type is json
     */
    @JvmName("mkqcgdypnfyturlf")
    public suspend fun jsonKeys(argument: suspend StoreIndexFieldSearchJsonKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StoreIndexFieldSearchJsonKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.jsonKeys = mapped
    }

    /**
     * @param values Use nested index when type is json
     */
    @JvmName("ushjamrmeiwtjeck")
    public suspend fun jsonKeys(vararg values: StoreIndexFieldSearchJsonKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jsonKeys = mapped
    }

    /**
     * @param value The field name, which is unique in the same log store.
     */
    @JvmName("jlqqfrdejqljvjci")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The string of several split words, like "\r", "#". It is valid when "type" is "text" or "json".
     */
    @JvmName("ancjydnxanmtdciu")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param value The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
     */
    @JvmName("eppbxevjidxlsnmm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): StoreIndexFieldSearchArgs = StoreIndexFieldSearchArgs(
        alias = alias,
        caseSensitive = caseSensitive,
        enableAnalytics = enableAnalytics,
        includeChinese = includeChinese,
        jsonKeys = jsonKeys,
        name = name ?: throw PulumiNullFieldException("name"),
        token = token,
        type = type,
    )
}
