@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchJsonKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alias The alias of one field.
 * @property docValue Whether to enable statistics. default to true.
 * > **Note:** At least one of the "full_text" and "field_search" should be specified.
 * @property name When using the json_keys field, this field is required.
 * @property type The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
 */
public data class StoreIndexFieldSearchJsonKeyArgs(
    public val alias: Output<String>? = null,
    public val docValue: Output<Boolean>? = null,
    public val name: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchJsonKeyArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchJsonKeyArgs =
        com.pulumi.alicloud.log.inputs.StoreIndexFieldSearchJsonKeyArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .docValue(docValue?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StoreIndexFieldSearchJsonKeyArgs].
 */
@PulumiTagMarker
public class StoreIndexFieldSearchJsonKeyArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var docValue: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The alias of one field.
     */
    @JvmName("mnllgprjcfqwydpi")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Whether to enable statistics. default to true.
     * > **Note:** At least one of the "full_text" and "field_search" should be specified.
     */
    @JvmName("nwrvaaufffaqurdw")
    public suspend fun docValue(`value`: Output<Boolean>) {
        this.docValue = value
    }

    /**
     * @param value When using the json_keys field, this field is required.
     */
    @JvmName("vausjrlohvwgugur")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
     */
    @JvmName("vmayuqnvockprggx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The alias of one field.
     */
    @JvmName("pqlhtwtuxovlhyuf")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Whether to enable statistics. default to true.
     * > **Note:** At least one of the "full_text" and "field_search" should be specified.
     */
    @JvmName("gdmxxtdxqmeviqvp")
    public suspend fun docValue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.docValue = mapped
    }

    /**
     * @param value When using the json_keys field, this field is required.
     */
    @JvmName("nkmvpnwuwjnhrcxa")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
     */
    @JvmName("uugbpoukfbeftahu")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): StoreIndexFieldSearchJsonKeyArgs = StoreIndexFieldSearchJsonKeyArgs(
        alias = alias,
        docValue = docValue,
        name = name ?: throw PulumiNullFieldException("name"),
        type = type,
    )
}
