@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.inputs

import com.pulumi.alicloud.log.inputs.StoreIndexFullTextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property caseSensitive Whether the case sensitive. Default to false.
 * @property includeChinese Whether includes the chinese. Default to false.
 * @property token The string of several split words, like "\r", "#"
 */
public data class StoreIndexFullTextArgs(
    public val caseSensitive: Output<Boolean>? = null,
    public val includeChinese: Output<Boolean>? = null,
    public val token: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.log.inputs.StoreIndexFullTextArgs> {
    override fun toJava(): com.pulumi.alicloud.log.inputs.StoreIndexFullTextArgs =
        com.pulumi.alicloud.log.inputs.StoreIndexFullTextArgs.builder()
            .caseSensitive(caseSensitive?.applyValue({ args0 -> args0 }))
            .includeChinese(includeChinese?.applyValue({ args0 -> args0 }))
            .token(token?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StoreIndexFullTextArgs].
 */
@PulumiTagMarker
public class StoreIndexFullTextArgsBuilder internal constructor() {
    private var caseSensitive: Output<Boolean>? = null

    private var includeChinese: Output<Boolean>? = null

    private var token: Output<String>? = null

    /**
     * @param value Whether the case sensitive. Default to false.
     */
    @JvmName("soxxmkjqeoynqcki")
    public suspend fun caseSensitive(`value`: Output<Boolean>) {
        this.caseSensitive = value
    }

    /**
     * @param value Whether includes the chinese. Default to false.
     */
    @JvmName("hgmgijbbcqrkvtjx")
    public suspend fun includeChinese(`value`: Output<Boolean>) {
        this.includeChinese = value
    }

    /**
     * @param value The string of several split words, like "\r", "#"
     */
    @JvmName("vdsjociocqgrhlfl")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value Whether the case sensitive. Default to false.
     */
    @JvmName("gnggssdevnqjqomf")
    public suspend fun caseSensitive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caseSensitive = mapped
    }

    /**
     * @param value Whether includes the chinese. Default to false.
     */
    @JvmName("vxudxuhsiqdqcgpr")
    public suspend fun includeChinese(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeChinese = mapped
    }

    /**
     * @param value The string of several split words, like "\r", "#"
     */
    @JvmName("nqgoqtklqpgkxvlf")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    internal fun build(): StoreIndexFullTextArgs = StoreIndexFullTextArgs(
        caseSensitive = caseSensitive,
        includeChinese = includeChinese,
        token = token,
    )
}
