@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property content Notice content of alarm.
 * @property emailLists Email address list.
 * @property mobileLists SMS sending mobile number.
 * @property serviceUri Request address.
 * @property type Notification type. support Email, SMS, DingTalk, MessageCenter.
 */
public data class AlertNotificationList(
    public val content: String,
    public val emailLists: List<String>? = null,
    public val mobileLists: List<String>? = null,
    public val serviceUri: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.AlertNotificationList): AlertNotificationList = AlertNotificationList(
            content = javaType.content(),
            emailLists = javaType.emailLists().map({ args0 -> args0 }),
            mobileLists = javaType.mobileLists().map({ args0 -> args0 }),
            serviceUri = javaType.serviceUri().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
