@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionPolicyId Action Policy Id.
 * @property alertPolicyId Alert Policy Id.
 * @property repeatInterval Repeat interval used by alert policy, 1h, 1m.e.g.
 */
public data class AlertPolicyConfiguration(
    public val actionPolicyId: String? = null,
    public val alertPolicyId: String,
    public val repeatInterval: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.AlertPolicyConfiguration): AlertPolicyConfiguration = AlertPolicyConfiguration(
            actionPolicyId = javaType.actionPolicyId().map({ args0 -> args0 }).orElse(null),
            alertPolicyId = javaType.alertPolicyId(),
            repeatInterval = javaType.repeatInterval(),
        )
    }
}
