@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property chartTitle Chart title, optional from 1.161.0+.
 * @property dashboardId Query dashboard id.
 * @property end End time. example: 20s.
 * @property logstore Query logstore, use store for new alert, Deprecated from 1.161.0+.
 * @property powerSqlMode default disable, whether to use power sql. support auto, enable, disable.
 * @property project Query project.
 * @property query Query corresponding to chart. example: * AND aliyun.
 * @property region Query project region.
 * @property roleArn Query project store's ARN.
 * @property start Begin time. example: -60s.
 * @property store Query store for new alert.
 * @property storeType Query store type for new alert, including log,metric,meta.
 * @property timeSpanType default Custom. No need to configure this parameter.
 */
public data class AlertQueryList(
    public val chartTitle: String? = null,
    public val dashboardId: String? = null,
    public val end: String,
    @Deprecated(
        message = """
  Deprecated from 1.161.0+, use store
  """,
    )
    public val logstore: String? = null,
    public val powerSqlMode: String? = null,
    public val project: String? = null,
    public val query: String,
    public val region: String? = null,
    public val roleArn: String? = null,
    public val start: String,
    public val store: String? = null,
    public val storeType: String? = null,
    public val timeSpanType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.AlertQueryList): AlertQueryList =
            AlertQueryList(
                chartTitle = javaType.chartTitle().map({ args0 -> args0 }).orElse(null),
                dashboardId = javaType.dashboardId().map({ args0 -> args0 }).orElse(null),
                end = javaType.end(),
                logstore = javaType.logstore().map({ args0 -> args0 }).orElse(null),
                powerSqlMode = javaType.powerSqlMode().map({ args0 -> args0 }).orElse(null),
                project = javaType.project().map({ args0 -> args0 }).orElse(null),
                query = javaType.query(),
                region = javaType.region().map({ args0 -> args0 }).orElse(null),
                roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
                start = javaType.start(),
                store = javaType.store().map({ args0 -> args0 }).orElse(null),
                storeType = javaType.storeType().map({ args0 -> args0 }).orElse(null),
                timeSpanType = javaType.timeSpanType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
