@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cronExpression Cron expression when type is Cron.
 * @property dayOfWeek Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
 * @property delay
 * @property hour Hour of day when type is Weekly/Daily.
 * @property interval Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
 * @property runImmediately
 * @property timeZone Time zone for schedule.
 * @property type including FixedRate,Hourly,Daily,Weekly,Cron.
 */
public data class AlertSchedule(
    public val cronExpression: String? = null,
    public val dayOfWeek: Int? = null,
    public val delay: Int? = null,
    public val hour: Int? = null,
    public val interval: String? = null,
    public val runImmediately: Boolean? = null,
    public val timeZone: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.AlertSchedule): AlertSchedule =
            AlertSchedule(
                cronExpression = javaType.cronExpression().map({ args0 -> args0 }).orElse(null),
                dayOfWeek = javaType.dayOfWeek().map({ args0 -> args0 }).orElse(null),
                delay = javaType.delay().map({ args0 -> args0 }).orElse(null),
                hour = javaType.hour().map({ args0 -> args0 }).orElse(null),
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                runImmediately = javaType.runImmediately().map({ args0 -> args0 }).orElse(null),
                timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
