@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property evalCondition Severity when this condition is met.
 * @property severity Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
 */
public data class AlertSeverityConfiguration(
    public val evalCondition: Map<String, String>,
    public val severity: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.AlertSeverityConfiguration): AlertSeverityConfiguration = AlertSeverityConfiguration(
            evalCondition = javaType.evalCondition().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            severity = javaType.severity(),
        )
    }
}
