@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property annotations Alert template annotations.
 * @property id Alert template id.
 * @property lang Alert template language including `cn`, `en`.
 * @property tokens Alert template tokens.
 * @property type Alert template type including `sys`, `user`.
 */
public data class AlertTemplateConfiguration(
    public val annotations: Map<String, String>? = null,
    public val id: String,
    public val lang: String? = null,
    public val tokens: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.AlertTemplateConfiguration): AlertTemplateConfiguration = AlertTemplateConfiguration(
            annotations = javaType.annotations().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            tokens = javaType.tokens().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
