@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessKeyId Delivery target logstore access key id.
 * @property accessKeySecret Delivery target logstore access key secret.
 * @property endpoint Delivery target logstore region.
 * @property kmsEncryptedAccessKeyId An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
 * @property kmsEncryptedAccessKeySecret An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
 * @property logstore Delivery target logstore.
 * @property name Delivery target name.
 * @property project The project where the target logstore is delivered.
 * @property roleArn Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
 * @property type ETL sinks type, the default value is AliyunLOG.
 * > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
 */
public data class EtlEtlSink(
    public val accessKeyId: String? = null,
    public val accessKeySecret: String? = null,
    public val endpoint: String,
    public val kmsEncryptedAccessKeyId: String? = null,
    public val kmsEncryptedAccessKeySecret: String? = null,
    public val logstore: String,
    public val name: String,
    public val project: String,
    public val roleArn: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.EtlEtlSink): EtlEtlSink =
            EtlEtlSink(
                accessKeyId = javaType.accessKeyId().map({ args0 -> args0 }).orElse(null),
                accessKeySecret = javaType.accessKeySecret().map({ args0 -> args0 }).orElse(null),
                endpoint = javaType.endpoint(),
                kmsEncryptedAccessKeyId = javaType.kmsEncryptedAccessKeyId().map({ args0 -> args0 }).orElse(null),
                kmsEncryptedAccessKeySecret = javaType.kmsEncryptedAccessKeySecret().map({ args0 ->
                    args0
                }).orElse(null),
                logstore = javaType.logstore(),
                name = javaType.name(),
                project = javaType.project(),
                roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
