@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAlertResource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lang
 * @property project
 * @property type
 */
public data class GetAlertResourceResult(
    public val id: String,
    public val lang: String? = null,
    public val project: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.GetAlertResourceResult): GetAlertResourceResult = GetAlertResourceResult(
            id = javaType.id(),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
