@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the project.
 * @property id The ID of the project.
 * @property lastModifyTime The last modify time of project.
 * @property owner The owner of project.
 * @property policy The policy of project.
 * @property projectName The name of the project.
 * @property region The region of project.
 * @property status The status of project.
 */
public data class GetProjectsProject(
    public val description: String,
    public val id: String,
    public val lastModifyTime: String,
    public val owner: String,
    public val policy: String,
    public val projectName: String,
    public val region: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.GetProjectsProject): GetProjectsProject = GetProjectsProject(
            description = javaType.description(),
            id = javaType.id(),
            lastModifyTime = javaType.lastModifyTime(),
            owner = javaType.owner(),
            policy = javaType.policy(),
            projectName = javaType.projectName(),
            region = javaType.region(),
            status = javaType.status(),
        )
    }
}
