@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getStores.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property project
 * @property stores
 */
public data class GetStoresResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val project: String,
    public val stores: List<GetStoresStore>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.GetStoresResult): GetStoresResult = GetStoresResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            project = javaType.project(),
            stores = javaType.stores().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.log.kotlin.outputs.GetStoresStore.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
