@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enable Enable encryption. Default false.
 * @property encryptType Supported encryption type, only supports `default`(AES), `m4`.
 * @property userCmkInfo User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
 */
public data class StoreEncryptConf(
    public val enable: Boolean? = null,
    public val encryptType: String? = null,
    public val userCmkInfo: StoreEncryptConfUserCmkInfo? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.StoreEncryptConf): StoreEncryptConf = StoreEncryptConf(
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            encryptType = javaType.encryptType().map({ args0 -> args0 }).orElse(null),
            userCmkInfo = javaType.userCmkInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.log.kotlin.outputs.StoreEncryptConfUserCmkInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
