@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alias The alias of one field
 * @property caseSensitive Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
 * @property enableAnalytics Whether to enable field analytics. Default to true.
 * @property includeChinese Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
 * @property jsonKeys Use nested index when type is json
 * @property name The field name, which is unique in the same log store.
 * @property token The string of several split words, like "\r", "#". It is valid when "type" is "text" or "json".
 * @property type The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
 */
public data class StoreIndexFieldSearch(
    public val alias: String? = null,
    public val caseSensitive: Boolean? = null,
    public val enableAnalytics: Boolean? = null,
    public val includeChinese: Boolean? = null,
    public val jsonKeys: List<StoreIndexFieldSearchJsonKey>? = null,
    public val name: String,
    public val token: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.StoreIndexFieldSearch): StoreIndexFieldSearch = StoreIndexFieldSearch(
            alias = javaType.alias().map({ args0 -> args0 }).orElse(null),
            caseSensitive = javaType.caseSensitive().map({ args0 -> args0 }).orElse(null),
            enableAnalytics = javaType.enableAnalytics().map({ args0 -> args0 }).orElse(null),
            includeChinese = javaType.includeChinese().map({ args0 -> args0 }).orElse(null),
            jsonKeys = javaType.jsonKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.log.kotlin.outputs.StoreIndexFieldSearchJsonKey.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            token = javaType.token().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
