@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alias The alias of one field.
 * @property docValue Whether to enable statistics. default to true.
 * > **Note:** At least one of the "full_text" and "field_search" should be specified.
 * @property name When using the json_keys field, this field is required.
 * @property type The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
 */
public data class StoreIndexFieldSearchJsonKey(
    public val alias: String? = null,
    public val docValue: Boolean? = null,
    public val name: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.StoreIndexFieldSearchJsonKey): StoreIndexFieldSearchJsonKey = StoreIndexFieldSearchJsonKey(
            alias = javaType.alias().map({ args0 -> args0 }).orElse(null),
            docValue = javaType.docValue().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
