@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property caseSensitive Whether the case sensitive. Default to false.
 * @property includeChinese Whether includes the chinese. Default to false.
 * @property token The string of several split words, like "\r", "#"
 */
public data class StoreIndexFullText(
    public val caseSensitive: Boolean? = null,
    public val includeChinese: Boolean? = null,
    public val token: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.StoreIndexFullText): StoreIndexFullText = StoreIndexFullText(
            caseSensitive = javaType.caseSensitive().map({ args0 -> args0 }).orElse(null),
            includeChinese = javaType.includeChinese().map({ args0 -> args0 }).orElse(null),
            token = javaType.token().map({ args0 -> args0 }).orElse(null),
        )
    }
}
