@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.log.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property beginKey The begin value of the shard range(MD5), included in the shard range.
 * @property endKey The end value of the shard range(MD5), not included in shard range.
 * @property id The ID of the shard.
 * @property status Shard status, only two status of `readwrite` and `readonly`.
 */
public data class StoreShard(
    public val beginKey: String? = null,
    public val endKey: String? = null,
    public val id: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.log.outputs.StoreShard): StoreShard =
            StoreShard(
                beginKey = javaType.beginKey().map({ args0 -> args0 }).orElse(null),
                endKey = javaType.endKey().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
