@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin

import com.pulumi.alicloud.marketplace.MarketplaceFunctions.getProductPlain
import com.pulumi.alicloud.marketplace.MarketplaceFunctions.getProductsPlain
import com.pulumi.alicloud.marketplace.kotlin.inputs.GetProductPlainArgs
import com.pulumi.alicloud.marketplace.kotlin.inputs.GetProductPlainArgsBuilder
import com.pulumi.alicloud.marketplace.kotlin.inputs.GetProductsPlainArgs
import com.pulumi.alicloud.marketplace.kotlin.inputs.GetProductsPlainArgsBuilder
import com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductResult
import com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductsResult
import kotlinx.coroutines.future.await
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductResult.Companion.toKotlin as getProductResultToKotlin
import com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductsResult.Companion.toKotlin as getProductsResultToKotlin

public object MarketplaceFunctions {
    /**
     * This data source provides the Market product item details of Alibaba Cloud.
     * > **NOTE:** Available in 1.69.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.marketplace.getProduct({
     *     productCode: "cmapi022206",
     * });
     * export const productName = _default.then(_default => _default.products?.[0]?.name);
     * export const firstProductSkuCode = _default.then(_default => _default.products?.[0]?&#46;skuses?&#46;[0]?.skuCode);
     * export const firstProductPackageVersion = _default.then(_default => _default.products?.[0]?&#46;skuses?&#46;[0]?&#46;packageVersions?&#46;[0]?.packageVersion);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.marketplace.get_product(product_code="cmapi022206")
     * pulumi.export("productName", default.products[0].name)
     * pulumi.export("firstProductSkuCode", default.products[0]&#46;skuses[0].sku_code)
     * pulumi.export("firstProductPackageVersion", default.products[0]&#46;skuses[0]&#46;package_versions[0].package_version)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.MarketPlace.GetProduct.Invoke(new()
     *     {
     *         ProductCode = "cmapi022206",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["productName"] = @default&#46;Apply(@default => @default&#46;Apply(getProductResult => getProductResult&#46;Products[0]?.Name)),
     *         ["firstProductSkuCode"] = @default&#46;Apply(@default => @default&#46;Apply(getProductResult => getProductResult&#46;Products[0]?&#46;Skuses[0]?.SkuCode)),
     *         ["firstProductPackageVersion"] = @default&#46;Apply(@default => @default&#46;Apply(getProductResult => getProductResult&#46;Products[0]?&#46;Skuses[0]?&#46;PackageVersions[0]?.PackageVersion)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/marketplace"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := marketplace.GetProduct(ctx, &marketplace.GetProductArgs{
     * 			ProductCode: "cmapi022206",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("productName", _default.Products[0].Name)
     * 		ctx.Export("firstProductSkuCode", _default.Products[0]&#46;Skuses[0].SkuCode)
     * 		ctx.Export("firstProductPackageVersion", _default.Products[0]&#46;Skuses[0]&#46;PackageVersions[0].PackageVersion)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.marketplace.MarketplaceFunctions;
     * import com.pulumi.alicloud.marketplace.inputs.GetProductArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = MarketplaceFunctions.getProduct(GetProductArgs.builder()
     *             .productCode("cmapi022206")
     *             .build());
     *         ctx.export("productName", default_.products()[0].name());
     *         ctx.export("firstProductSkuCode", default_.products()[0]&#46;skuses()[0].skuCode());
     *         ctx.export("firstProductPackageVersion", default_.products()[0]&#46;skuses()[0]&#46;packageVersions()[0].packageVersion());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:marketplace:getProduct
     *       Arguments:
     *         productCode: cmapi022206
     * outputs:
     *   productName: ${default.products[0].name}
     *   firstProductSkuCode: ${default.products[0]&#46;skuses[0].skuCode}
     *   firstProductPackageVersion: ${default.products[0]&#46;skuses[0]&#46;packageVersions[0].packageVersion}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProduct.
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(argument: GetProductPlainArgs): GetProductResult =
        getProductResultToKotlin(getProductPlain(argument.toJava()).await())

    /**
     * @see [getProduct].
     * @param availableRegion A available region id used to filter market place Ecs images.
     * @param productCode The product code of the market product.
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(availableRegion: String? = null, productCode: String): GetProductResult {
        val argument = GetProductPlainArgs(
            availableRegion = availableRegion,
            productCode = productCode,
        )
        return getProductResultToKotlin(getProductPlain(argument.toJava()).await())
    }

    /**
     * @see [getProduct].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;marketplace&#46;kotlin&#46;inputs&#46;GetProductPlainArgs].
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(argument: suspend GetProductPlainArgsBuilder.() -> Unit): GetProductResult {
        val builder = GetProductPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductResultToKotlin(getProductPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Market product items of Alibaba Cloud.
     * > **NOTE:** Available in 1.64.0+
     * @param argument A collection of arguments for invoking getProducts.
     * @return A collection of values returned by getProducts.
     */
    public suspend fun getProducts(argument: GetProductsPlainArgs): GetProductsResult =
        getProductsResultToKotlin(getProductsPlain(argument.toJava()).await())

    /**
     * @see [getProducts].
     * @param categoryId The Category ID of products.
     * @param ids A list of product code.
     * @param nameRegex A regex string to apply to the product name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productType The type of products, Valid values: `APP`, `SERVICE`, `MIRROR`, `DOWNLOAD` and `API_SERVICE`.
     * @param searchTerm Search term in this query.
     * @param sort This field determines how to sort the filtered results, Valid values: `user_count-desc`, `created_on-desc`, `price-desc` and `score-desc`.
     * @param suggestedPrice The suggested price of the product.
     * @param supplierId The supplier id of the product.
     * @param supplierNameKeyword The supplier name keyword of the product.
     * @return A collection of values returned by getProducts.
     */
    public suspend fun getProducts(
        categoryId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        productType: String? = null,
        searchTerm: String? = null,
        sort: String? = null,
        suggestedPrice: Double? = null,
        supplierId: String? = null,
        supplierNameKeyword: String? = null,
    ): GetProductsResult {
        val argument = GetProductsPlainArgs(
            categoryId = categoryId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            productType = productType,
            searchTerm = searchTerm,
            sort = sort,
            suggestedPrice = suggestedPrice,
            supplierId = supplierId,
            supplierNameKeyword = supplierNameKeyword,
        )
        return getProductsResultToKotlin(getProductsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProducts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;marketplace&#46;kotlin&#46;inputs&#46;GetProductsPlainArgs].
     * @return A collection of values returned by getProducts.
     */
    public suspend fun getProducts(argument: suspend GetProductsPlainArgsBuilder.() -> Unit): GetProductsResult {
        val builder = GetProductsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProductsResultToKotlin(getProductsPlain(builtArgument.toJava()).await())
    }
}
