@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Order].
 */
@PulumiTagMarker
public class OrderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrderArgs = OrderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrderArgsBuilder.() -> Unit) {
        val builder = OrderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Order {
        val builtJavaResource = com.pulumi.alicloud.marketplace.Order(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Order(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const order = new alicloud.marketplace.Order("order", {
 *     productCode: "cmapi033136",
 *     payType: "prepay",
 *     quantity: 1,
 *     duration: 1,
 *     pricingCycle: "Month",
 *     packageVersion: "yuncode2713600001",
 *     couponId: "",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * order = alicloud.marketplace.Order("order",
 *     product_code="cmapi033136",
 *     pay_type="prepay",
 *     quantity=1,
 *     duration=1,
 *     pricing_cycle="Month",
 *     package_version="yuncode2713600001",
 *     coupon_id="")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var order = new AliCloud.MarketPlace.Order("order", new()
 *     {
 *         ProductCode = "cmapi033136",
 *         PayType = "prepay",
 *         Quantity = 1,
 *         Duration = 1,
 *         PricingCycle = "Month",
 *         PackageVersion = "yuncode2713600001",
 *         CouponId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/marketplace"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := marketplace.NewOrder(ctx, "order", &marketplace.OrderArgs{
 * 			ProductCode:    pulumi.String("cmapi033136"),
 * 			PayType:        pulumi.String("prepay"),
 * 			Quantity:       pulumi.Int(1),
 * 			Duration:       pulumi.Int(1),
 * 			PricingCycle:   pulumi.String("Month"),
 * 			PackageVersion: pulumi.String("yuncode2713600001"),
 * 			CouponId:       pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.marketplace.Order;
 * import com.pulumi.alicloud.marketplace.OrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var order = new Order("order", OrderArgs.builder()
 *             .productCode("cmapi033136")
 *             .payType("prepay")
 *             .quantity(1)
 *             .duration(1)
 *             .pricingCycle("Month")
 *             .packageVersion("yuncode2713600001")
 *             .couponId("")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   order:
 *     type: alicloud:marketplace:Order
 *     properties:
 *       productCode: cmapi033136
 *       payType: prepay
 *       quantity: 1
 *       duration: 1
 *       pricingCycle: Month
 *       packageVersion: yuncode2713600001
 *       couponId:
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Market order can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:marketplace/order:Order order your-order-id
 * ```
 */
public class Order internal constructor(
    override val javaResource: com.pulumi.alicloud.marketplace.Order,
) : KotlinCustomResource(javaResource, OrderMapper) {
    /**
     * Service providers customize additional components.
     */
    public val components: Output<Map<String, String>>?
        get() = javaResource.components().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The coupon id of the market product.
     */
    public val couponId: Output<String>?
        get() = javaResource.couponId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The number of purchase cycles.
     */
    public val duration: Output<Int>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The package version of the market product.
     */
    public val packageVersion: Output<String>
        get() = javaResource.packageVersion().applyValue({ args0 -> args0 })

    /**
     * Valid values are `PrePaid`, `PostPaid`,System default to `PostPaid`.
     */
    public val payType: Output<String>?
        get() = javaResource.payType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The purchase cycle of the product, valid values are `Day`, `Month` and `Year`.
     */
    public val pricingCycle: Output<String>
        get() = javaResource.pricingCycle().applyValue({ args0 -> args0 })

    /**
     * The product_code of market place product.
     */
    public val productCode: Output<String>
        get() = javaResource.productCode().applyValue({ args0 -> args0 })

    /**
     * The quantity of the market product will be purchased.
     */
    public val quantity: Output<Int>?
        get() = javaResource.quantity().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object OrderMapper : ResourceMapper<Order> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.marketplace.Order::class == javaResource::class

    override fun map(javaResource: Resource): Order = Order(
        javaResource as
            com.pulumi.alicloud.marketplace.Order,
    )
}

/**
 * @see [Order].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Order].
 */
public suspend fun order(name: String, block: suspend OrderResourceBuilder.() -> Unit): Order {
    val builder = OrderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Order].
 * @param name The _unique_ name of the resulting resource.
 */
public fun order(name: String): Order {
    val builder = OrderResourceBuilder()
    builder.name(name)
    return builder.build()
}
