@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin

import com.pulumi.alicloud.marketplace.OrderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const order = new alicloud.marketplace.Order("order", {
 *     productCode: "cmapi033136",
 *     payType: "prepay",
 *     quantity: 1,
 *     duration: 1,
 *     pricingCycle: "Month",
 *     packageVersion: "yuncode2713600001",
 *     couponId: "",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * order = alicloud.marketplace.Order("order",
 *     product_code="cmapi033136",
 *     pay_type="prepay",
 *     quantity=1,
 *     duration=1,
 *     pricing_cycle="Month",
 *     package_version="yuncode2713600001",
 *     coupon_id="")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var order = new AliCloud.MarketPlace.Order("order", new()
 *     {
 *         ProductCode = "cmapi033136",
 *         PayType = "prepay",
 *         Quantity = 1,
 *         Duration = 1,
 *         PricingCycle = "Month",
 *         PackageVersion = "yuncode2713600001",
 *         CouponId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/marketplace"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := marketplace.NewOrder(ctx, "order", &marketplace.OrderArgs{
 * 			ProductCode:    pulumi.String("cmapi033136"),
 * 			PayType:        pulumi.String("prepay"),
 * 			Quantity:       pulumi.Int(1),
 * 			Duration:       pulumi.Int(1),
 * 			PricingCycle:   pulumi.String("Month"),
 * 			PackageVersion: pulumi.String("yuncode2713600001"),
 * 			CouponId:       pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.marketplace.Order;
 * import com.pulumi.alicloud.marketplace.OrderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var order = new Order("order", OrderArgs.builder()
 *             .productCode("cmapi033136")
 *             .payType("prepay")
 *             .quantity(1)
 *             .duration(1)
 *             .pricingCycle("Month")
 *             .packageVersion("yuncode2713600001")
 *             .couponId("")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   order:
 *     type: alicloud:marketplace:Order
 *     properties:
 *       productCode: cmapi033136
 *       payType: prepay
 *       quantity: 1
 *       duration: 1
 *       pricingCycle: Month
 *       packageVersion: yuncode2713600001
 *       couponId:
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Market order can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:marketplace/order:Order order your-order-id
 * ```
 * @property components Service providers customize additional components.
 * @property couponId The coupon id of the market product.
 * @property duration The number of purchase cycles.
 * @property packageVersion The package version of the market product.
 * @property payType Valid values are `PrePaid`, `PostPaid`,System default to `PostPaid`.
 * @property pricingCycle The purchase cycle of the product, valid values are `Day`, `Month` and `Year`.
 * @property productCode The product_code of market place product.
 * @property quantity The quantity of the market product will be purchased.
 */
public data class OrderArgs(
    public val components: Output<Map<String, String>>? = null,
    public val couponId: Output<String>? = null,
    public val duration: Output<Int>? = null,
    public val packageVersion: Output<String>? = null,
    public val payType: Output<String>? = null,
    public val pricingCycle: Output<String>? = null,
    public val productCode: Output<String>? = null,
    public val quantity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.marketplace.OrderArgs> {
    override fun toJava(): com.pulumi.alicloud.marketplace.OrderArgs =
        com.pulumi.alicloud.marketplace.OrderArgs.builder()
            .components(
                components?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .couponId(couponId?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .packageVersion(packageVersion?.applyValue({ args0 -> args0 }))
            .payType(payType?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .quantity(quantity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrderArgs].
 */
@PulumiTagMarker
public class OrderArgsBuilder internal constructor() {
    private var components: Output<Map<String, String>>? = null

    private var couponId: Output<String>? = null

    private var duration: Output<Int>? = null

    private var packageVersion: Output<String>? = null

    private var payType: Output<String>? = null

    private var pricingCycle: Output<String>? = null

    private var productCode: Output<String>? = null

    private var quantity: Output<Int>? = null

    /**
     * @param value Service providers customize additional components.
     */
    @JvmName("kuyvoxouhlfuggor")
    public suspend fun components(`value`: Output<Map<String, String>>) {
        this.components = value
    }

    /**
     * @param value The coupon id of the market product.
     */
    @JvmName("uyvalhkusllemtsc")
    public suspend fun couponId(`value`: Output<String>) {
        this.couponId = value
    }

    /**
     * @param value The number of purchase cycles.
     */
    @JvmName("trdnypekkmtkwhun")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value The package version of the market product.
     */
    @JvmName("nfdylculgnsjsfml")
    public suspend fun packageVersion(`value`: Output<String>) {
        this.packageVersion = value
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`,System default to `PostPaid`.
     */
    @JvmName("vwttnmcwigibqjse")
    public suspend fun payType(`value`: Output<String>) {
        this.payType = value
    }

    /**
     * @param value The purchase cycle of the product, valid values are `Day`, `Month` and `Year`.
     */
    @JvmName("sbxhsdmcdhntfnkl")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value The product_code of market place product.
     */
    @JvmName("tmmeiefdhtapofog")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value The quantity of the market product will be purchased.
     */
    @JvmName("mntermhplhieqvyi")
    public suspend fun quantity(`value`: Output<Int>) {
        this.quantity = value
    }

    /**
     * @param value Service providers customize additional components.
     */
    @JvmName("dhheqiiuxneevpwu")
    public suspend fun components(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param values Service providers customize additional components.
     */
    @JvmName("fsxxlpidkrnxxkoc")
    public fun components(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param value The coupon id of the market product.
     */
    @JvmName("mmxttpruckhdliff")
    public suspend fun couponId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.couponId = mapped
    }

    /**
     * @param value The number of purchase cycles.
     */
    @JvmName("gglaaphccqdvpsrh")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The package version of the market product.
     */
    @JvmName("bkleopfxeqmdcpyj")
    public suspend fun packageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageVersion = mapped
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`,System default to `PostPaid`.
     */
    @JvmName("efnpnjfkmiewvqub")
    public suspend fun payType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payType = mapped
    }

    /**
     * @param value The purchase cycle of the product, valid values are `Day`, `Month` and `Year`.
     */
    @JvmName("qnlcdjdpkuahlgqe")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value The product_code of market place product.
     */
    @JvmName("kupbiumiymuxskwq")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value The quantity of the market product will be purchased.
     */
    @JvmName("xrgdifikdnrxgofk")
    public suspend fun quantity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quantity = mapped
    }

    internal fun build(): OrderArgs = OrderArgs(
        components = components,
        couponId = couponId,
        duration = duration,
        packageVersion = packageVersion,
        payType = payType,
        pricingCycle = pricingCycle,
        productCode = productCode,
        quantity = quantity,
    )
}
