@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin.inputs

import com.pulumi.alicloud.marketplace.inputs.GetProductPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProduct.
 * @property availableRegion A available region id used to filter market place Ecs images.
 * @property productCode The product code of the market product.
 */
public data class GetProductPlainArgs(
    public val availableRegion: String? = null,
    public val productCode: String,
) : ConvertibleToJava<com.pulumi.alicloud.marketplace.inputs.GetProductPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.marketplace.inputs.GetProductPlainArgs =
        com.pulumi.alicloud.marketplace.inputs.GetProductPlainArgs.builder()
            .availableRegion(availableRegion?.let({ args0 -> args0 }))
            .productCode(productCode.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductPlainArgs].
 */
@PulumiTagMarker
public class GetProductPlainArgsBuilder internal constructor() {
    private var availableRegion: String? = null

    private var productCode: String? = null

    /**
     * @param value A available region id used to filter market place Ecs images.
     */
    @JvmName("jxmthajevfcqgffp")
    public suspend fun availableRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availableRegion = mapped
    }

    /**
     * @param value The product code of the market product.
     */
    @JvmName("utthqdmiqmndhmhh")
    public suspend fun productCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productCode = mapped
    }

    internal fun build(): GetProductPlainArgs = GetProductPlainArgs(
        availableRegion = availableRegion,
        productCode = productCode ?: throw PulumiNullFieldException("productCode"),
    )
}
