@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin.inputs

import com.pulumi.alicloud.marketplace.inputs.GetProductsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProducts.
 * @property categoryId The Category ID of products.
 * @property ids A list of product code.
 * @property nameRegex A regex string to apply to the product name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productType The type of products, Valid values: `APP`, `SERVICE`, `MIRROR`, `DOWNLOAD` and `API_SERVICE`.
 * @property searchTerm Search term in this query.
 * @property sort This field determines how to sort the filtered results, Valid values: `user_count-desc`, `created_on-desc`, `price-desc` and `score-desc`.
 * @property suggestedPrice The suggested price of the product.
 * @property supplierId The supplier id of the product.
 * @property supplierNameKeyword The supplier name keyword of the product.
 */
public data class GetProductsPlainArgs(
    public val categoryId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val productType: String? = null,
    public val searchTerm: String? = null,
    public val sort: String? = null,
    public val suggestedPrice: Double? = null,
    public val supplierId: String? = null,
    public val supplierNameKeyword: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.marketplace.inputs.GetProductsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.marketplace.inputs.GetProductsPlainArgs =
        com.pulumi.alicloud.marketplace.inputs.GetProductsPlainArgs.builder()
            .categoryId(categoryId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productType(productType?.let({ args0 -> args0 }))
            .searchTerm(searchTerm?.let({ args0 -> args0 }))
            .sort(sort?.let({ args0 -> args0 }))
            .suggestedPrice(suggestedPrice?.let({ args0 -> args0 }))
            .supplierId(supplierId?.let({ args0 -> args0 }))
            .supplierNameKeyword(supplierNameKeyword?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductsPlainArgs].
 */
@PulumiTagMarker
public class GetProductsPlainArgsBuilder internal constructor() {
    private var categoryId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var productType: String? = null

    private var searchTerm: String? = null

    private var sort: String? = null

    private var suggestedPrice: Double? = null

    private var supplierId: String? = null

    private var supplierNameKeyword: String? = null

    /**
     * @param value The Category ID of products.
     */
    @JvmName("xmlxfahvrlrubdmf")
    public suspend fun categoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.categoryId = mapped
    }

    /**
     * @param value A list of product code.
     */
    @JvmName("yaoosedxgrjwrfhd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of product code.
     */
    @JvmName("uslluoclvoxphsww")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to apply to the product name.
     */
    @JvmName("dtvoombyuucjgahw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ukxoulxfaigpcmwq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The type of products, Valid values: `APP`, `SERVICE`, `MIRROR`, `DOWNLOAD` and `API_SERVICE`.
     */
    @JvmName("smymrujqlbrfjhxj")
    public suspend fun productType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productType = mapped
    }

    /**
     * @param value Search term in this query.
     */
    @JvmName("xkrsyphflqayliyj")
    public suspend fun searchTerm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchTerm = mapped
    }

    /**
     * @param value This field determines how to sort the filtered results, Valid values: `user_count-desc`, `created_on-desc`, `price-desc` and `score-desc`.
     */
    @JvmName("chsyhywsqpmlsbbx")
    public suspend fun sort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sort = mapped
    }

    /**
     * @param value The suggested price of the product.
     */
    @JvmName("uetjirvediixromo")
    public suspend fun suggestedPrice(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.suggestedPrice = mapped
    }

    /**
     * @param value The supplier id of the product.
     */
    @JvmName("ppjrkxsleosxewyq")
    public suspend fun supplierId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supplierId = mapped
    }

    /**
     * @param value The supplier name keyword of the product.
     */
    @JvmName("olsokvkqakhssdyj")
    public suspend fun supplierNameKeyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supplierNameKeyword = mapped
    }

    internal fun build(): GetProductsPlainArgs = GetProductsPlainArgs(
        categoryId = categoryId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        productType = productType,
        searchTerm = searchTerm,
        sort = sort,
        suggestedPrice = suggestedPrice,
        supplierId = supplierId,
        supplierNameKeyword = supplierNameKeyword,
    )
}
