@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property code The code of the product.
 * @property description The description of the product.
 * @property name The name of the product.
 * @property skuses A list of one element containing sku attributes of an object. Each element contains the following attributes:
 */
public data class GetProductProduct(
    public val code: String,
    public val description: String,
    public val name: String,
    public val skuses: List<GetProductProductSkus>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.marketplace.outputs.GetProductProduct): GetProductProduct = GetProductProduct(
            code = javaType.code(),
            description = javaType.description(),
            name = javaType.name(),
            skuses = javaType.skuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductProductSkus.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
