@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property images The list of custom ECS images, Each element contains the following attributes:
 * @property packageVersions The list of package version details of this product sku, Each element contains the following attributes:
 * @property skuCode The sku code of this product sku.
 * @property skuName The sku name of this product sku.
 */
public data class GetProductProductSkus(
    public val images: List<GetProductProductSkusImage>,
    public val packageVersions: List<GetProductProductSkusPackageVersion>,
    public val skuCode: String,
    public val skuName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.marketplace.outputs.GetProductProductSkus): GetProductProductSkus = GetProductProductSkus(
            images = javaType.images().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductProductSkusImage.Companion.toKotlin(args0)
                })
            }),
            packageVersions = javaType.packageVersions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductProductSkusPackageVersion.Companion.toKotlin(args0)
                })
            }),
            skuCode = javaType.skuCode(),
            skuName = javaType.skuName(),
        )
    }
}
