@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property packageName The package name of this product sku package.
 * @property packageVersion The package version of this product sku package. Currently, the API products can return package_version, but others can not for ensure.
 */
public data class GetProductProductSkusPackageVersion(
    public val packageName: String,
    public val packageVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.marketplace.outputs.GetProductProductSkusPackageVersion): GetProductProductSkusPackageVersion = GetProductProductSkusPackageVersion(
            packageName = javaType.packageName(),
            packageVersion = javaType.packageVersion(),
        )
    }
}
