@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProduct.
 * @property availableRegion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property productCode
 * @property products A product. It contains the following attributes:
 */
public data class GetProductResult(
    public val availableRegion: String? = null,
    public val id: String,
    public val productCode: String,
    public val products: List<GetProductProduct>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.marketplace.outputs.GetProductResult): GetProductResult = GetProductResult(
            availableRegion = javaType.availableRegion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            productCode = javaType.productCode(),
            products = javaType.products().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductProduct.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
