@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property categoryId The Category ID of products.
 * @property code The code of the product.
 * @property deliveryDate The delivery date of the product.
 * @property deliveryWay The delivery way of the product.
 * @property imageUrl The image URL of the product.
 * @property name The name of the product.
 * @property operationSystem The operation system of the product.
 * @property score The rating information of the product.
 * @property shortDescription The short description of the product.
 * @property suggestedPrice The suggested price of the product.
 * @property supplierId The supplier id of the product.
 * @property supplierName The supplier name of the product.
 * @property tags The tags of the product.
 * @property targetUrl The detail page URL of the product.
 * @property warrantyDate The warranty date of the product.
 */
public data class GetProductsProduct(
    public val categoryId: Int,
    public val code: String,
    public val deliveryDate: String,
    public val deliveryWay: String,
    public val imageUrl: String,
    public val name: String,
    public val operationSystem: String,
    public val score: String,
    public val shortDescription: String,
    public val suggestedPrice: String,
    public val supplierId: Int,
    public val supplierName: String,
    public val tags: String,
    public val targetUrl: String,
    public val warrantyDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.marketplace.outputs.GetProductsProduct): GetProductsProduct = GetProductsProduct(
            categoryId = javaType.categoryId(),
            code = javaType.code(),
            deliveryDate = javaType.deliveryDate(),
            deliveryWay = javaType.deliveryWay(),
            imageUrl = javaType.imageUrl(),
            name = javaType.name(),
            operationSystem = javaType.operationSystem(),
            score = javaType.score(),
            shortDescription = javaType.shortDescription(),
            suggestedPrice = javaType.suggestedPrice(),
            supplierId = javaType.supplierId(),
            supplierName = javaType.supplierName(),
            tags = javaType.tags(),
            targetUrl = javaType.targetUrl(),
            warrantyDate = javaType.warrantyDate(),
        )
    }
}
