@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.marketplace.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProducts.
 * @property categoryId The category id of the product.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of product codes.
 * @property nameRegex
 * @property outputFile
 * @property productType
 * @property products A list of products. Each element contains the following attributes:
 * @property searchTerm
 * @property sort
 * @property suggestedPrice The suggested price of the product.
 * @property supplierId The supplier id of the product.
 * @property supplierNameKeyword
 */
public data class GetProductsResult(
    public val categoryId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val productType: String? = null,
    public val products: List<GetProductsProduct>,
    public val searchTerm: String? = null,
    public val sort: String? = null,
    public val suggestedPrice: Double? = null,
    public val supplierId: String? = null,
    public val supplierNameKeyword: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.marketplace.outputs.GetProductsResult): GetProductsResult = GetProductsResult(
            categoryId = javaType.categoryId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            productType = javaType.productType().map({ args0 -> args0 }).orElse(null),
            products = javaType.products().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.marketplace.kotlin.outputs.GetProductsProduct.Companion.toKotlin(args0)
                })
            }),
            searchTerm = javaType.searchTerm().map({ args0 -> args0 }).orElse(null),
            sort = javaType.sort().map({ args0 -> args0 }).orElse(null),
            suggestedPrice = javaType.suggestedPrice().map({ args0 -> args0 }).orElse(null),
            supplierId = javaType.supplierId().map({ args0 -> args0 }).orElse(null),
            supplierNameKeyword = javaType.supplierNameKeyword().map({ args0 -> args0 }).orElse(null),
        )
    }
}
