@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin

import com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectIpWhiteList
import com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectProperties
import com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectSecurityProperties
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectIpWhiteList.Companion.toKotlin as projectIpWhiteListToKotlin
import com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectProperties.Companion.toKotlin as projectPropertiesToKotlin
import com.pulumi.alicloud.maxcompute.kotlin.outputs.ProjectSecurityProperties.Companion.toKotlin as projectSecurityPropertiesToKotlin

/**
 * Builder for [Project].
 */
@PulumiTagMarker
public class ProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectArgs = ProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectArgsBuilder.() -> Unit) {
        val builder = ProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Project {
        val builtJavaResource = com.pulumi.alicloud.maxcompute.Project(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Project(builtJavaResource)
    }
}

/**
 * Provides a Max Compute Project resource.
 * MaxCompute project .
 * For information about Max Compute Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/maxcompute/).
 * > **NOTE:** Available since v1.77.0.
 * > **NOTE:** Field `name`, `specification_type`, `order_type` has been removed from provider version 1.227.1.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.maxcompute.Project("default", {
 *     defaultQuota: "默认后付费Quota",
 *     projectName: name,
 *     comment: name,
 *     productType: "PayAsYouGo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.maxcompute.Project("default",
 *     default_quota="默认后付费Quota",
 *     project_name=name,
 *     comment=name,
 *     product_type="PayAsYouGo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.MaxCompute.Project("default", new()
 *     {
 *         DefaultQuota = "默认后付费Quota",
 *         ProjectName = name,
 *         Comment = name,
 *         ProductType = "PayAsYouGo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/maxcompute"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := maxcompute.NewProject(ctx, "default", &maxcompute.ProjectArgs{
 * 			DefaultQuota: pulumi.String("默认后付费Quota"),
 * 			ProjectName:  pulumi.String(name),
 * 			Comment:      pulumi.String(name),
 * 			ProductType:  pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.maxcompute.Project;
 * import com.pulumi.alicloud.maxcompute.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Project("default", ProjectArgs.builder()
 *             .defaultQuota("默认后付费Quota")
 *             .projectName(name)
 *             .comment(name)
 *             .productType("PayAsYouGo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:maxcompute:Project
 *     properties:
 *       defaultQuota: 默认后付费Quota
 *       projectName: ${name}
 *       comment: ${name}
 *       productType: PayAsYouGo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Max Compute Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:maxcompute/project:Project example <id>
 * ```
 */
public class Project internal constructor(
    override val javaResource: com.pulumi.alicloud.maxcompute.Project,
) : KotlinCustomResource(javaResource, ProjectMapper) {
    /**
     * Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Represents the creation time of the project
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Used to implement computing resource allocation. If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
     */
    public val defaultQuota: Output<String>?
        get() = javaResource.defaultQuota().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * IP whitelist See `ip_white_list` below.
     */
    public val ipWhiteList: Output<ProjectIpWhiteList>?
        get() = javaResource.ipWhiteList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectIpWhiteListToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Logical deletion, value: (true/false) true: In this case, the project status will be changed to 'DELETING' and completely deleted after 14 days. false: immediately deleted, that is, completely deleted, permanently unrecoverable.
     */
    public val isLogical: Output<String>?
        get() = javaResource.isLogical().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Project owner
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * Quota payment type, support `PayAsYouGo`, `Subscription`, `Dev`.
     */
    public val productType: Output<String>?
        get() = javaResource.productType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * Project base attributes See `properties` below.
     */
    public val properties: Output<ProjectProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                projectPropertiesToKotlin(args0)
            })
        })

    /**
     * Security-related attributes See `security_properties` below.
     */
    public val securityProperties: Output<ProjectSecurityProperties>
        get() = javaResource.securityProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                projectSecurityPropertiesToKotlin(args0)
            })
        })

    /**
     * The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Project type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProjectMapper : ResourceMapper<Project> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.maxcompute.Project::class == javaResource::class

    override fun map(javaResource: Resource): Project = Project(
        javaResource as
            com.pulumi.alicloud.maxcompute.Project,
    )
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Project].
 */
public suspend fun project(name: String, block: suspend ProjectResourceBuilder.() -> Unit): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 */
public fun project(name: String): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
