@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin

import com.pulumi.alicloud.maxcompute.ProjectArgs.builder
import com.pulumi.alicloud.maxcompute.kotlin.inputs.ProjectIpWhiteListArgs
import com.pulumi.alicloud.maxcompute.kotlin.inputs.ProjectIpWhiteListArgsBuilder
import com.pulumi.alicloud.maxcompute.kotlin.inputs.ProjectPropertiesArgs
import com.pulumi.alicloud.maxcompute.kotlin.inputs.ProjectPropertiesArgsBuilder
import com.pulumi.alicloud.maxcompute.kotlin.inputs.ProjectSecurityPropertiesArgs
import com.pulumi.alicloud.maxcompute.kotlin.inputs.ProjectSecurityPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Max Compute Project resource.
 * MaxCompute project .
 * For information about Max Compute Project and how to use it, see [What is Project](https://www.alibabacloud.com/help/en/maxcompute/).
 * > **NOTE:** Available since v1.77.0.
 * > **NOTE:** Field `name`, `specification_type`, `order_type` has been removed from provider version 1.227.1.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.maxcompute.Project("default", {
 *     defaultQuota: "默认后付费Quota",
 *     projectName: name,
 *     comment: name,
 *     productType: "PayAsYouGo",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.maxcompute.Project("default",
 *     default_quota="默认后付费Quota",
 *     project_name=name,
 *     comment=name,
 *     product_type="PayAsYouGo")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.MaxCompute.Project("default", new()
 *     {
 *         DefaultQuota = "默认后付费Quota",
 *         ProjectName = name,
 *         Comment = name,
 *         ProductType = "PayAsYouGo",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/maxcompute"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := maxcompute.NewProject(ctx, "default", &maxcompute.ProjectArgs{
 * 			DefaultQuota: pulumi.String("默认后付费Quota"),
 * 			ProjectName:  pulumi.String(name),
 * 			Comment:      pulumi.String(name),
 * 			ProductType:  pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.maxcompute.Project;
 * import com.pulumi.alicloud.maxcompute.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new Project("default", ProjectArgs.builder()
 *             .defaultQuota("默认后付费Quota")
 *             .projectName(name)
 *             .comment(name)
 *             .productType("PayAsYouGo")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:maxcompute:Project
 *     properties:
 *       defaultQuota: 默认后付费Quota
 *       projectName: ${name}
 *       comment: ${name}
 *       productType: PayAsYouGo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Max Compute Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:maxcompute/project:Project example <id>
 * ```
 * @property comment Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
 * @property defaultQuota Used to implement computing resource allocation. If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
 * @property ipWhiteList IP whitelist See `ip_white_list` below.
 * @property isLogical Logical deletion, value: (true/false) true: In this case, the project status will be changed to 'DELETING' and completely deleted after 14 days. false: immediately deleted, that is, completely deleted, permanently unrecoverable.
 * @property productType Quota payment type, support `PayAsYouGo`, `Subscription`, `Dev`.
 * @property projectName The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
 * @property properties Project base attributes See `properties` below.
 * @property securityProperties Security-related attributes See `security_properties` below.
 * @property status The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
 * @property tags The tag of the resource
 */
public data class ProjectArgs(
    public val comment: Output<String>? = null,
    public val defaultQuota: Output<String>? = null,
    public val ipWhiteList: Output<ProjectIpWhiteListArgs>? = null,
    public val isLogical: Output<String>? = null,
    public val productType: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<ProjectPropertiesArgs>? = null,
    public val securityProperties: Output<ProjectSecurityPropertiesArgs>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.maxcompute.ProjectArgs> {
    override fun toJava(): com.pulumi.alicloud.maxcompute.ProjectArgs =
        com.pulumi.alicloud.maxcompute.ProjectArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .defaultQuota(defaultQuota?.applyValue({ args0 -> args0 }))
            .ipWhiteList(ipWhiteList?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isLogical(isLogical?.applyValue({ args0 -> args0 }))
            .productType(productType?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityProperties(
                securityProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var defaultQuota: Output<String>? = null

    private var ipWhiteList: Output<ProjectIpWhiteListArgs>? = null

    private var isLogical: Output<String>? = null

    private var productType: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<ProjectPropertiesArgs>? = null

    private var securityProperties: Output<ProjectSecurityPropertiesArgs>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
     */
    @JvmName("iaamxptceqcqfhap")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Used to implement computing resource allocation. If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
     */
    @JvmName("yqfsikuaqohuxqiw")
    public suspend fun defaultQuota(`value`: Output<String>) {
        this.defaultQuota = value
    }

    /**
     * @param value IP whitelist See `ip_white_list` below.
     */
    @JvmName("aetcxdilqhwloaer")
    public suspend fun ipWhiteList(`value`: Output<ProjectIpWhiteListArgs>) {
        this.ipWhiteList = value
    }

    /**
     * @param value Logical deletion, value: (true/false) true: In this case, the project status will be changed to 'DELETING' and completely deleted after 14 days. false: immediately deleted, that is, completely deleted, permanently unrecoverable.
     */
    @JvmName("blcmnheqcrwmenhp")
    public suspend fun isLogical(`value`: Output<String>) {
        this.isLogical = value
    }

    /**
     * @param value Quota payment type, support `PayAsYouGo`, `Subscription`, `Dev`.
     */
    @JvmName("rjiejgbkcevfjqpj")
    public suspend fun productType(`value`: Output<String>) {
        this.productType = value
    }

    /**
     * @param value The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
     */
    @JvmName("wsfbcqqvtxfogpvq")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Project base attributes See `properties` below.
     */
    @JvmName("ukuhtuatlonpauko")
    public suspend fun properties(`value`: Output<ProjectPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Security-related attributes See `security_properties` below.
     */
    @JvmName("wnljibhmyudvvtke")
    public suspend fun securityProperties(`value`: Output<ProjectSecurityPropertiesArgs>) {
        this.securityProperties = value
    }

    /**
     * @param value The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
     */
    @JvmName("vxgyjomxheeujeyl")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("mgojplcgktmgffca")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
     */
    @JvmName("pcakghwsiwgkfnkd")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Used to implement computing resource allocation. If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
     */
    @JvmName("metbbiycsnhesyku")
    public suspend fun defaultQuota(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultQuota = mapped
    }

    /**
     * @param value IP whitelist See `ip_white_list` below.
     */
    @JvmName("homgpkuhftqbnpkv")
    public suspend fun ipWhiteList(`value`: ProjectIpWhiteListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipWhiteList = mapped
    }

    /**
     * @param argument IP whitelist See `ip_white_list` below.
     */
    @JvmName("mrnwsjanqrxkifut")
    public suspend fun ipWhiteList(argument: suspend ProjectIpWhiteListArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectIpWhiteListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipWhiteList = mapped
    }

    /**
     * @param value Logical deletion, value: (true/false) true: In this case, the project status will be changed to 'DELETING' and completely deleted after 14 days. false: immediately deleted, that is, completely deleted, permanently unrecoverable.
     */
    @JvmName("vtvjvvesquhrlvqv")
    public suspend fun isLogical(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLogical = mapped
    }

    /**
     * @param value Quota payment type, support `PayAsYouGo`, `Subscription`, `Dev`.
     */
    @JvmName("whjnjeyqrkcdbpub")
    public suspend fun productType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productType = mapped
    }

    /**
     * @param value The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
     */
    @JvmName("eqgofkliqgepxmiq")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Project base attributes See `properties` below.
     */
    @JvmName("ophgccfoawmfwlbv")
    public suspend fun properties(`value`: ProjectPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Project base attributes See `properties` below.
     */
    @JvmName("srbdirvrrkgfumkr")
    public suspend fun properties(argument: suspend ProjectPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Security-related attributes See `security_properties` below.
     */
    @JvmName("gmcugjwyljkkubii")
    public suspend fun securityProperties(`value`: ProjectSecurityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProperties = mapped
    }

    /**
     * @param argument Security-related attributes See `security_properties` below.
     */
    @JvmName("tdielovscrmldrov")
    public suspend fun securityProperties(argument: suspend ProjectSecurityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectSecurityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProperties = mapped
    }

    /**
     * @param value The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
     */
    @JvmName("oxcfbfltcqvlxaee")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("wgsmcvfxfhssldoh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource
     */
    @JvmName("tgurdloyrgeurcwy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        comment = comment,
        defaultQuota = defaultQuota,
        ipWhiteList = ipWhiteList,
        isLogical = isLogical,
        productType = productType,
        projectName = projectName,
        properties = properties,
        securityProperties = securityProperties,
        status = status,
        tags = tags,
    )
}
