@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.inputs

import com.pulumi.alicloud.maxcompute.inputs.ProjectIpWhiteListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipList Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.> **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
 * @property vpcIpList Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.> **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
 */
public data class ProjectIpWhiteListArgs(
    public val ipList: Output<String>? = null,
    public val vpcIpList: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.maxcompute.inputs.ProjectIpWhiteListArgs> {
    override fun toJava(): com.pulumi.alicloud.maxcompute.inputs.ProjectIpWhiteListArgs =
        com.pulumi.alicloud.maxcompute.inputs.ProjectIpWhiteListArgs.builder()
            .ipList(ipList?.applyValue({ args0 -> args0 }))
            .vpcIpList(vpcIpList?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectIpWhiteListArgs].
 */
@PulumiTagMarker
public class ProjectIpWhiteListArgsBuilder internal constructor() {
    private var ipList: Output<String>? = null

    private var vpcIpList: Output<String>? = null

    /**
     * @param value Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.> **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
     */
    @JvmName("pvjteijptkpbwoes")
    public suspend fun ipList(`value`: Output<String>) {
        this.ipList = value
    }

    /**
     * @param value Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.> **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
     */
    @JvmName("sgxklabelvhicdwv")
    public suspend fun vpcIpList(`value`: Output<String>) {
        this.vpcIpList = value
    }

    /**
     * @param value Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.> **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
     */
    @JvmName("kxakotrnrxthbinb")
    public suspend fun ipList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipList = mapped
    }

    /**
     * @param value Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.> **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
     */
    @JvmName("bojwyoupxwylavfb")
    public suspend fun vpcIpList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcIpList = mapped
    }

    internal fun build(): ProjectIpWhiteListArgs = ProjectIpWhiteListArgs(
        ipList = ipList,
        vpcIpList = vpcIpList,
    )
}
