@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.inputs

import com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allowFullScan Whether to allow full table scan. Default: false.
 * @property enableDecimal2 Whether to turn on Decimal2.0.
 * @property encryption Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
 * > **NOTE :**:  To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.  To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.  You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
 * @property retentionDays Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off. The effective policy after adjusting the backup cycle is: Extend the backup cycle: The new backup cycle takes effect on the same day. Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
 * @property sqlMeteringMax Set the maximum threshold of single SQL consumption, that is, set the ODPS. SQL. metering.value.max attribute. For details, see [Consumption Monitoring Alarm](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control). Unit: scan volume (GB)* complexity. .
 * @property tableLifecycle Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property,. See `table_lifecycle` below.
 * @property timezone Project time zone, example value: Asia/Shanghai.
 * @property typeSystem Data type version. Value:(1/2/hive) 1: The original MaxCompute type system. 2: New type system introduced by MaxCompute 2.0. hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
 */
public data class ProjectPropertiesArgs(
    public val allowFullScan: Output<Boolean>? = null,
    public val enableDecimal2: Output<Boolean>? = null,
    public val encryption: Output<ProjectPropertiesEncryptionArgs>? = null,
    public val retentionDays: Output<Int>? = null,
    public val sqlMeteringMax: Output<String>? = null,
    public val tableLifecycle: Output<ProjectPropertiesTableLifecycleArgs>? = null,
    public val timezone: Output<String>? = null,
    public val typeSystem: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesArgs> {
    override fun toJava(): com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesArgs =
        com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesArgs.builder()
            .allowFullScan(allowFullScan?.applyValue({ args0 -> args0 }))
            .enableDecimal2(enableDecimal2?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .sqlMeteringMax(sqlMeteringMax?.applyValue({ args0 -> args0 }))
            .tableLifecycle(tableLifecycle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timezone(timezone?.applyValue({ args0 -> args0 }))
            .typeSystem(typeSystem?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectPropertiesArgs].
 */
@PulumiTagMarker
public class ProjectPropertiesArgsBuilder internal constructor() {
    private var allowFullScan: Output<Boolean>? = null

    private var enableDecimal2: Output<Boolean>? = null

    private var encryption: Output<ProjectPropertiesEncryptionArgs>? = null

    private var retentionDays: Output<Int>? = null

    private var sqlMeteringMax: Output<String>? = null

    private var tableLifecycle: Output<ProjectPropertiesTableLifecycleArgs>? = null

    private var timezone: Output<String>? = null

    private var typeSystem: Output<String>? = null

    /**
     * @param value Whether to allow full table scan. Default: false.
     */
    @JvmName("clcktnvnpcvxabff")
    public suspend fun allowFullScan(`value`: Output<Boolean>) {
        this.allowFullScan = value
    }

    /**
     * @param value Whether to turn on Decimal2.0.
     */
    @JvmName("hpjohrknmosccfum")
    public suspend fun enableDecimal2(`value`: Output<Boolean>) {
        this.enableDecimal2 = value
    }

    /**
     * @param value Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
     * > **NOTE :**:  To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.  To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.  You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
     */
    @JvmName("mounqntcshhjkauk")
    public suspend fun encryption(`value`: Output<ProjectPropertiesEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off. The effective policy after adjusting the backup cycle is: Extend the backup cycle: The new backup cycle takes effect on the same day. Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
     */
    @JvmName("oqddoxpqkmrsoccy")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value Set the maximum threshold of single SQL consumption, that is, set the ODPS. SQL. metering.value.max attribute. For details, see [Consumption Monitoring Alarm](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control). Unit: scan volume (GB)* complexity. .
     */
    @JvmName("rhskqdaesfrpssei")
    public suspend fun sqlMeteringMax(`value`: Output<String>) {
        this.sqlMeteringMax = value
    }

    /**
     * @param value Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property,. See `table_lifecycle` below.
     */
    @JvmName("tqhcsjrdlyflxehw")
    public suspend fun tableLifecycle(`value`: Output<ProjectPropertiesTableLifecycleArgs>) {
        this.tableLifecycle = value
    }

    /**
     * @param value Project time zone, example value: Asia/Shanghai.
     */
    @JvmName("agqpodkmiqwygclm")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value Data type version. Value:(1/2/hive) 1: The original MaxCompute type system. 2: New type system introduced by MaxCompute 2.0. hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
     */
    @JvmName("obhybamfoipabmwj")
    public suspend fun typeSystem(`value`: Output<String>) {
        this.typeSystem = value
    }

    /**
     * @param value Whether to allow full table scan. Default: false.
     */
    @JvmName("pwnehjxeqmpdxjng")
    public suspend fun allowFullScan(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowFullScan = mapped
    }

    /**
     * @param value Whether to turn on Decimal2.0.
     */
    @JvmName("aigbjmqqmgqhjhil")
    public suspend fun enableDecimal2(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDecimal2 = mapped
    }

    /**
     * @param value Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
     * > **NOTE :**:  To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.  To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.  You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
     */
    @JvmName("xgqlophmgurvinit")
    public suspend fun encryption(`value`: ProjectPropertiesEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
     * > **NOTE :**:  To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.  To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.  You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
     */
    @JvmName("sindyjlmprunetym")
    public suspend fun encryption(argument: suspend ProjectPropertiesEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectPropertiesEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off. The effective policy after adjusting the backup cycle is: Extend the backup cycle: The new backup cycle takes effect on the same day. Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
     */
    @JvmName("hvtbjysclbftkcbb")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value Set the maximum threshold of single SQL consumption, that is, set the ODPS. SQL. metering.value.max attribute. For details, see [Consumption Monitoring Alarm](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control). Unit: scan volume (GB)* complexity. .
     */
    @JvmName("ooyhvqbismsgkipo")
    public suspend fun sqlMeteringMax(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlMeteringMax = mapped
    }

    /**
     * @param value Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property,. See `table_lifecycle` below.
     */
    @JvmName("ejlaceqkmclrgvrx")
    public suspend fun tableLifecycle(`value`: ProjectPropertiesTableLifecycleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableLifecycle = mapped
    }

    /**
     * @param argument Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property,. See `table_lifecycle` below.
     */
    @JvmName("ajloomiwwwwbohjr")
    public suspend fun tableLifecycle(argument: suspend ProjectPropertiesTableLifecycleArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectPropertiesTableLifecycleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tableLifecycle = mapped
    }

    /**
     * @param value Project time zone, example value: Asia/Shanghai.
     */
    @JvmName("mwhdljwsoayjgmcb")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    /**
     * @param value Data type version. Value:(1/2/hive) 1: The original MaxCompute type system. 2: New type system introduced by MaxCompute 2.0. hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
     */
    @JvmName("qddfjwyhgragncmn")
    public suspend fun typeSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeSystem = mapped
    }

    internal fun build(): ProjectPropertiesArgs = ProjectPropertiesArgs(
        allowFullScan = allowFullScan,
        enableDecimal2 = enableDecimal2,
        encryption = encryption,
        retentionDays = retentionDays,
        sqlMeteringMax = sqlMeteringMax,
        tableLifecycle = tableLifecycle,
        timezone = timezone,
        typeSystem = typeSystem,
    )
}
