@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.inputs

import com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property algorithm The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
 * @property enable Only enable function is supported. Value: (true).
 * @property key The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
 */
public data class ProjectPropertiesEncryptionArgs(
    public val algorithm: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val key: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesEncryptionArgs> {
    override fun toJava(): com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesEncryptionArgs =
        com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesEncryptionArgs.builder()
            .algorithm(algorithm?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectPropertiesEncryptionArgs].
 */
@PulumiTagMarker
public class ProjectPropertiesEncryptionArgsBuilder internal constructor() {
    private var algorithm: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var key: Output<String>? = null

    /**
     * @param value The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
     */
    @JvmName("jfmroybybgixjbvp")
    public suspend fun algorithm(`value`: Output<String>) {
        this.algorithm = value
    }

    /**
     * @param value Only enable function is supported. Value: (true).
     */
    @JvmName("sdemisviytjwsiuj")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
     */
    @JvmName("fwfqwqoofknfmyth")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
     */
    @JvmName("dtrtnmljdbixerac")
    public suspend fun algorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value Only enable function is supported. Value: (true).
     */
    @JvmName("tsdvshmkgfljsnsg")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
     */
    @JvmName("iiwtulhqaovuomeq")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): ProjectPropertiesEncryptionArgs = ProjectPropertiesEncryptionArgs(
        algorithm = algorithm,
        enable = enable,
        key = key,
    )
}
