@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.inputs

import com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesTableLifecycleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Project type
 * @property value The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
 */
public data class ProjectPropertiesTableLifecycleArgs(
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesTableLifecycleArgs> {
    override fun toJava(): com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesTableLifecycleArgs =
        com.pulumi.alicloud.maxcompute.inputs.ProjectPropertiesTableLifecycleArgs.builder()
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectPropertiesTableLifecycleArgs].
 */
@PulumiTagMarker
public class ProjectPropertiesTableLifecycleArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Project type
     */
    @JvmName("tffwxakfrnwkdgwk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
     */
    @JvmName("mhbwfdosfhngtasj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Project type
     */
    @JvmName("pdgrjrjgqofkstby")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
     */
    @JvmName("sappxriukfsrlwne")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ProjectPropertiesTableLifecycleArgs = ProjectPropertiesTableLifecycleArgs(
        type = type,
        `value` = `value`,
    )
}
