@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.inputs

import com.pulumi.alicloud.maxcompute.inputs.ProjectSecurityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enableDownloadPrivilege Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
 * @property labelSecurity Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
 * @property objectCreatorHasAccessPermission Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
 * @property objectCreatorHasGrantPermission The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
 * @property projectProtection Project protection. See `project_protection` below.
 * @property usingAcl Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
 * @property usingPolicy Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
 */
public data class ProjectSecurityPropertiesArgs(
    public val enableDownloadPrivilege: Output<Boolean>? = null,
    public val labelSecurity: Output<Boolean>? = null,
    public val objectCreatorHasAccessPermission: Output<Boolean>? = null,
    public val objectCreatorHasGrantPermission: Output<Boolean>? = null,
    public val projectProtection: Output<ProjectSecurityPropertiesProjectProtectionArgs>? = null,
    public val usingAcl: Output<Boolean>? = null,
    public val usingPolicy: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.maxcompute.inputs.ProjectSecurityPropertiesArgs> {
    override fun toJava(): com.pulumi.alicloud.maxcompute.inputs.ProjectSecurityPropertiesArgs =
        com.pulumi.alicloud.maxcompute.inputs.ProjectSecurityPropertiesArgs.builder()
            .enableDownloadPrivilege(enableDownloadPrivilege?.applyValue({ args0 -> args0 }))
            .labelSecurity(labelSecurity?.applyValue({ args0 -> args0 }))
            .objectCreatorHasAccessPermission(objectCreatorHasAccessPermission?.applyValue({ args0 -> args0 }))
            .objectCreatorHasGrantPermission(objectCreatorHasGrantPermission?.applyValue({ args0 -> args0 }))
            .projectProtection(projectProtection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .usingAcl(usingAcl?.applyValue({ args0 -> args0 }))
            .usingPolicy(usingPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSecurityPropertiesArgs].
 */
@PulumiTagMarker
public class ProjectSecurityPropertiesArgsBuilder internal constructor() {
    private var enableDownloadPrivilege: Output<Boolean>? = null

    private var labelSecurity: Output<Boolean>? = null

    private var objectCreatorHasAccessPermission: Output<Boolean>? = null

    private var objectCreatorHasGrantPermission: Output<Boolean>? = null

    private var projectProtection: Output<ProjectSecurityPropertiesProjectProtectionArgs>? = null

    private var usingAcl: Output<Boolean>? = null

    private var usingPolicy: Output<Boolean>? = null

    /**
     * @param value Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
     */
    @JvmName("lpsknnyrllpmsakl")
    public suspend fun enableDownloadPrivilege(`value`: Output<Boolean>) {
        this.enableDownloadPrivilege = value
    }

    /**
     * @param value Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
     */
    @JvmName("wafuchmuqqbdcoid")
    public suspend fun labelSecurity(`value`: Output<Boolean>) {
        this.labelSecurity = value
    }

    /**
     * @param value Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
     */
    @JvmName("usdsjumjmfgswmha")
    public suspend fun objectCreatorHasAccessPermission(`value`: Output<Boolean>) {
        this.objectCreatorHasAccessPermission = value
    }

    /**
     * @param value The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
     */
    @JvmName("mmjlppktwxvldnif")
    public suspend fun objectCreatorHasGrantPermission(`value`: Output<Boolean>) {
        this.objectCreatorHasGrantPermission = value
    }

    /**
     * @param value Project protection. See `project_protection` below.
     */
    @JvmName("iphnxwcqlwtwkpif")
    public suspend fun projectProtection(`value`: Output<ProjectSecurityPropertiesProjectProtectionArgs>) {
        this.projectProtection = value
    }

    /**
     * @param value Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
     */
    @JvmName("vnayrhjityqqjqge")
    public suspend fun usingAcl(`value`: Output<Boolean>) {
        this.usingAcl = value
    }

    /**
     * @param value Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
     */
    @JvmName("hewnlsjodnucbpxe")
    public suspend fun usingPolicy(`value`: Output<Boolean>) {
        this.usingPolicy = value
    }

    /**
     * @param value Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
     */
    @JvmName("riylbpphxgklrpsd")
    public suspend fun enableDownloadPrivilege(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDownloadPrivilege = mapped
    }

    /**
     * @param value Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
     */
    @JvmName("lkaubwjjbxanspba")
    public suspend fun labelSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelSecurity = mapped
    }

    /**
     * @param value Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
     */
    @JvmName("cbuodgpkglixkedp")
    public suspend fun objectCreatorHasAccessPermission(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectCreatorHasAccessPermission = mapped
    }

    /**
     * @param value The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
     */
    @JvmName("eopqyxjqdmovtcyx")
    public suspend fun objectCreatorHasGrantPermission(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectCreatorHasGrantPermission = mapped
    }

    /**
     * @param value Project protection. See `project_protection` below.
     */
    @JvmName("jloicotpsvgciwic")
    public suspend fun projectProtection(`value`: ProjectSecurityPropertiesProjectProtectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectProtection = mapped
    }

    /**
     * @param argument Project protection. See `project_protection` below.
     */
    @JvmName("qeufscrarjmxegvh")
    public suspend fun projectProtection(argument: suspend ProjectSecurityPropertiesProjectProtectionArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectSecurityPropertiesProjectProtectionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.projectProtection = mapped
    }

    /**
     * @param value Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
     */
    @JvmName("wtqgdenhqcogclco")
    public suspend fun usingAcl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usingAcl = mapped
    }

    /**
     * @param value Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
     */
    @JvmName("tunajeftagkupati")
    public suspend fun usingPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usingPolicy = mapped
    }

    internal fun build(): ProjectSecurityPropertiesArgs = ProjectSecurityPropertiesArgs(
        enableDownloadPrivilege = enableDownloadPrivilege,
        labelSecurity = labelSecurity,
        objectCreatorHasAccessPermission = objectCreatorHasAccessPermission,
        objectCreatorHasGrantPermission = objectCreatorHasGrantPermission,
        projectProtection = projectProtection,
        usingAcl = usingAcl,
        usingPolicy = usingPolicy,
    )
}
