@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.inputs

import com.pulumi.alicloud.maxcompute.inputs.ProjectSecurityPropertiesProjectProtectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exceptionPolicy Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection).
 * @property protected Whether enabled, value:(true/false).
 */
public data class ProjectSecurityPropertiesProjectProtectionArgs(
    public val exceptionPolicy: Output<String>? = null,
    public val `protected`: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.maxcompute.inputs.ProjectSecurityPropertiesProjectProtectionArgs> {
    override fun toJava(): com.pulumi.alicloud.maxcompute.inputs.ProjectSecurityPropertiesProjectProtectionArgs =
        com.pulumi.alicloud.maxcompute.inputs.ProjectSecurityPropertiesProjectProtectionArgs.builder()
            .exceptionPolicy(exceptionPolicy?.applyValue({ args0 -> args0 }))
            .protected_(`protected`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSecurityPropertiesProjectProtectionArgs].
 */
@PulumiTagMarker
public class ProjectSecurityPropertiesProjectProtectionArgsBuilder internal constructor() {
    private var exceptionPolicy: Output<String>? = null

    private var `protected`: Output<Boolean>? = null

    /**
     * @param value Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection).
     */
    @JvmName("xopirnybxmjppxmj")
    public suspend fun exceptionPolicy(`value`: Output<String>) {
        this.exceptionPolicy = value
    }

    /**
     * @param value Whether enabled, value:(true/false).
     */
    @JvmName("ijkruoochkwmpmmx")
    public suspend fun `protected`(`value`: Output<Boolean>) {
        this.`protected` = value
    }

    /**
     * @param value Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection).
     */
    @JvmName("lochywdhihjlymrs")
    public suspend fun exceptionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exceptionPolicy = mapped
    }

    /**
     * @param value Whether enabled, value:(true/false).
     */
    @JvmName("ifgqwjdpbgnhgfcy")
    public suspend fun `protected`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`protected` = mapped
    }

    internal fun build(): ProjectSecurityPropertiesProjectProtectionArgs =
        ProjectSecurityPropertiesProjectProtectionArgs(
            exceptionPolicy = exceptionPolicy,
            `protected` = `protected`,
        )
}
