@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comment Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
 * @property costStorage View the current storage size of the Project. The storage size is the same as the measurement size, that is, the compressed logical storage size collected by the Project.
 * @property createTime Represents the creation time of the project
 * @property defaultQuota Used to implement computing resource allocation.If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
 * @property ipWhiteList IP whitelist
 * @property owner Project owner
 * @property projectName The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
 * @property properties Project base attributes
 * @property securityProperties Security-related attributes
 * @property status The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
 * @property type Project type
 */
public data class GetProjectsProject(
    public val comment: String,
    public val costStorage: String,
    public val createTime: String,
    public val defaultQuota: String,
    public val ipWhiteList: GetProjectsProjectIpWhiteList,
    public val owner: String,
    public val projectName: String,
    public val properties: GetProjectsProjectProperties,
    public val securityProperties: GetProjectsProjectSecurityProperties,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.GetProjectsProject): GetProjectsProject = GetProjectsProject(
            comment = javaType.comment(),
            costStorage = javaType.costStorage(),
            createTime = javaType.createTime(),
            defaultQuota = javaType.defaultQuota(),
            ipWhiteList = javaType.ipWhiteList().let({ args0 ->
                com.pulumi.alicloud.maxcompute.kotlin.outputs.GetProjectsProjectIpWhiteList.Companion.toKotlin(args0)
            }),
            owner = javaType.owner(),
            projectName = javaType.projectName(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.alicloud.maxcompute.kotlin.outputs.GetProjectsProjectProperties.Companion.toKotlin(args0)
            }),
            securityProperties = javaType.securityProperties().let({ args0 ->
                com.pulumi.alicloud.maxcompute.kotlin.outputs.GetProjectsProjectSecurityProperties.Companion.toKotlin(args0)
            }),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
