@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipList Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.> **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
 * @property vpcIpList Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.> **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
 */
public data class GetProjectsProjectIpWhiteList(
    public val ipList: String,
    public val vpcIpList: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.GetProjectsProjectIpWhiteList): GetProjectsProjectIpWhiteList = GetProjectsProjectIpWhiteList(
            ipList = javaType.ipList(),
            vpcIpList = javaType.vpcIpList(),
        )
    }
}
