@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allowFullScan Whether to allow full table scan. Default: false.
 * @property enableDecimal2 Whether to turn on Decimal2.0.
 * @property encryption Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)> **NOTE :**:To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm.
 * @property retentionDays Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off.The effective policy after adjusting the backup cycle is:Extend the backup cycle: The new backup cycle takes effect on the same day.Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
 * @property sqlMeteringMax Set the maximum threshold of single SQL consumption, that is, set the ODPS. SQL. metering.value.max attribute. For details, see [Consumption Monitoring Alarm](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control).Unit: scan volume (GB)* complexity.
 * @property tableLifecycle Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property,.
 * @property timezone Project time zone, example value: Asia/Shanghai.
 * @property typeSystem Data type version. Value:(1/2/hive)1: The original MaxCompute type system.2: New type system introduced by MaxCompute 2.0.hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
 */
public data class GetProjectsProjectProperties(
    public val allowFullScan: Boolean,
    public val enableDecimal2: Boolean,
    public val encryption: GetProjectsProjectPropertiesEncryption,
    public val retentionDays: Int,
    public val sqlMeteringMax: String,
    public val tableLifecycle: GetProjectsProjectPropertiesTableLifecycle,
    public val timezone: String,
    public val typeSystem: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.GetProjectsProjectProperties): GetProjectsProjectProperties = GetProjectsProjectProperties(
            allowFullScan = javaType.allowFullScan(),
            enableDecimal2 = javaType.enableDecimal2(),
            encryption = javaType.encryption().let({ args0 ->
                com.pulumi.alicloud.maxcompute.kotlin.outputs.GetProjectsProjectPropertiesEncryption.Companion.toKotlin(args0)
            }),
            retentionDays = javaType.retentionDays(),
            sqlMeteringMax = javaType.sqlMeteringMax(),
            tableLifecycle = javaType.tableLifecycle().let({ args0 ->
                com.pulumi.alicloud.maxcompute.kotlin.outputs.GetProjectsProjectPropertiesTableLifecycle.Companion.toKotlin(args0)
            }),
            timezone = javaType.timezone(),
            typeSystem = javaType.typeSystem(),
        )
    }
}
