@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.maxcompute.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property algorithm The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
 * @property enable Only enable function is supported. Value: (true).
 * @property key The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
 */
public data class GetProjectsProjectPropertiesEncryption(
    public val algorithm: String,
    public val enable: Boolean,
    public val key: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.maxcompute.outputs.GetProjectsProjectPropertiesEncryption): GetProjectsProjectPropertiesEncryption = GetProjectsProjectPropertiesEncryption(
            algorithm = javaType.algorithm(),
            enable = javaType.enable(),
            key = javaType.key(),
        )
    }
}
